/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.SchemaObject;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import com.bea.common.security.xacml.context.MissingAttributeDetail;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusDetail
extends ContextSchemaObject {
    private static final long serialVersionUID = -460015619953319698L;
    private List<SchemaObject> details;

    public StatusDetail(List<SchemaObject> details) {
        this.details = details;
    }

    public StatusDetail(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<MissingAttributeDetail> details = new ArrayList<MissingAttributeDetail>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = this.getLocalName(child);
            if (!cname.equals("MissingAttributeDetail")) continue;
            details.add(new MissingAttributeDetail(registry, child));
        }
        this.details = details.isEmpty() ? null : Collections.unmodifiableList(details);
    }

    @Override
    public String getElementName() {
        return "StatusDetail";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.details != null) {
            for (SchemaObject so : this.details) {
                so.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StatusDetail)) {
            return false;
        }
        StatusDetail o = (StatusDetail)other;
        return CollectionUtil.equals(this.details, o.details);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.details);
        return result;
    }

    public List<SchemaObject> getStatusDetails() {
        return this.details;
    }
}

