/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.Attribute;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subject
extends ContextSchemaObject {
    private static final long serialVersionUID = -3272502530852421544L;
    private static final String ACCESS_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private URI subjectCategory;
    private List<Attribute> attributes;

    public Subject() {
        this((List<Attribute>)null, null);
    }

    public Subject(URI subjectCategory) {
        this(null, subjectCategory);
    }

    public Subject(List<Attribute> attributes) {
        this(attributes, null);
    }

    public Subject(List<Attribute> attributes, URI subjectCategory) {
        this.attributes = attributes != null ? Collections.unmodifiableList(attributes) : null;
        this.subjectCategory = subjectCategory;
    }

    public Subject(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        Node scNode = attrs.getNamedItem("SubjectCategory");
        try {
            this.subjectCategory = new URI(scNode != null ? scNode.getNodeValue() : ACCESS_SUBJECT);
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        this.attributes = new ArrayList<Attribute>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Attribute")) continue;
            this.attributes.add(new Attribute(registry, node));
        }
        this.attributes = this.attributes.isEmpty() ? null : Collections.unmodifiableList(this.attributes);
    }

    @Override
    public String getElementName() {
        return "Subject";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        super.encodeAttributes(ps);
        if (this.subjectCategory != null && !ACCESS_SUBJECT.equals(this.subjectCategory.toString())) {
            ps.print(" SubjectCategory=\"");
            ps.print(this.subjectCategory);
            ps.print("\"");
        }
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.attributes != null) {
            for (Attribute a : this.attributes) {
                a.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Subject)) {
            return false;
        }
        Subject o = (Subject)other;
        return CollectionUtil.equals(this.attributes, o.attributes) && (this.subjectCategory == o.subjectCategory || this.subjectCategory != null && this.subjectCategory.equals(o.subjectCategory) || this.subjectCategory == null && ACCESS_SUBJECT.equals(o.subjectCategory) || o.subjectCategory == null && ACCESS_SUBJECT.equals(this.subjectCategory));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.attributes);
        result = HashCodeUtil.hash((int)result, (Object)(this.subjectCategory != null ? this.subjectCategory : ACCESS_SUBJECT));
        return result;
    }

    public URI getSubjectCategory() {
        return this.subjectCategory;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }
}

