/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Action;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Actions
extends PolicySchemaObject {
    private static final long serialVersionUID = 7219203161667986244L;
    private List<Action> contents;

    public Actions(List<Action> actions) {
        this.contents = actions != null ? Collections.unmodifiableList(actions) : null;
    }

    public Actions(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<Action> contents = new ArrayList<Action>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Action")) continue;
            contents.add(new Action(registry, node));
        }
        this.contents = Collections.unmodifiableList(contents);
    }

    @Override
    public String getElementName() {
        return "Actions";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.contents != null) {
            for (Action m : this.contents) {
                m.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Actions)) {
            return false;
        }
        Actions o = (Actions)other;
        return CollectionUtil.equals(this.contents, o.contents);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.contents);
        return result;
    }

    public List<Action> getActions() {
        return this.contents;
    }
}

