/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.SchemaObject;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Expression;
import com.bea.common.security.xacml.policy.ExpressionHandler;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apply
extends PolicySchemaObject
implements Expression {
    private static final long serialVersionUID = -152464173632063058L;
    private URI functionId;
    private List<Expression> expressions;

    public Apply(URI functionId, List<Expression> expressions) {
        this.functionId = functionId;
        this.expressions = expressions != null ? Collections.unmodifiableList(expressions) : null;
    }

    public Apply(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.functionId = new URI(attrs.getNamedItem("FunctionId").getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Expression e = ExpressionHandler.parseExpression(registry, node);
            if (e == null) continue;
            expressions.add(e);
        }
        this.expressions = Collections.unmodifiableList(expressions);
    }

    @Override
    public String getElementName() {
        return "Apply";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        ps.print(" FunctionId=\"");
        ps.print(this.functionId);
        ps.print('\"');
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.expressions != null) {
            Iterator<Expression> it = this.expressions.iterator();
            while (it.hasNext()) {
                ((SchemaObject)((Object)it.next())).encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Apply)) {
            return false;
        }
        Apply o = (Apply)other;
        return (this.functionId == o.functionId || this.functionId != null && this.functionId.equals(o.functionId)) && CollectionUtil.equals(this.expressions, o.expressions);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.functionId);
        result = HashCodeUtil.hash((int)result, this.expressions);
        return result;
    }

    public URI getFunctionId() {
        return this.functionId;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }
}

