/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.ActionAttributeDesignator;
import com.bea.common.security.xacml.policy.Apply;
import com.bea.common.security.xacml.policy.AttributeSelector;
import com.bea.common.security.xacml.policy.AttributeValue;
import com.bea.common.security.xacml.policy.Condition;
import com.bea.common.security.xacml.policy.EnvironmentAttributeDesignator;
import com.bea.common.security.xacml.policy.Expression;
import com.bea.common.security.xacml.policy.Function;
import com.bea.common.security.xacml.policy.ResourceAttributeDesignator;
import com.bea.common.security.xacml.policy.SubjectAttributeDesignator;
import com.bea.common.security.xacml.policy.VariableReference;
import org.w3c.dom.Node;

public class ExpressionHandler {
    private ExpressionHandler() {
    }

    public static Expression parseExpression(AttributeRegistry registry, Node node) throws URISyntaxException, DocumentParseException {
        if (node.getNodeName().equals("Apply")) {
            return new Apply(registry, node);
        }
        if (node.getNodeName().equals("Condition")) {
            return new Condition(registry, node);
        }
        if (node.getNodeName().equals("Function")) {
            return new Function(node);
        }
        if (node.getNodeName().equals("ResourceAttributeDesignator")) {
            return new ResourceAttributeDesignator(node);
        }
        if (node.getNodeName().equals("ActionAttributeDesignator")) {
            return new ActionAttributeDesignator(node);
        }
        if (node.getNodeName().equals("SubjectAttributeDesignator")) {
            return new SubjectAttributeDesignator(node);
        }
        if (node.getNodeName().equals("EnvironmentAttributeDesignator")) {
            return new EnvironmentAttributeDesignator(node);
        }
        if (node.getNodeName().equals("AttributeSelector")) {
            return new AttributeSelector(node);
        }
        if (node.getNodeName().equals("AttributeValue")) {
            com.bea.common.security.xacml.attr.AttributeValue av = registry.getAttribute(node);
            if (av != null) {
                return new AttributeValue(av);
            }
        } else if (node.getNodeName().equals("VariableReference")) {
            return new VariableReference(node);
        }
        return null;
    }
}

