/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.AbstractPolicy;
import com.bea.common.security.xacml.policy.CombinerParameters;
import com.bea.common.security.xacml.policy.IdReference;
import com.bea.common.security.xacml.policy.Obligations;
import com.bea.common.security.xacml.policy.PolicyDefaults;
import com.bea.common.security.xacml.policy.PolicyIdReference;
import com.bea.common.security.xacml.policy.Rule;
import com.bea.common.security.xacml.policy.RuleCombinerParameters;
import com.bea.common.security.xacml.policy.Target;
import com.bea.common.security.xacml.policy.VariableDefinition;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy
extends AbstractPolicy {
    private static final long serialVersionUID = 6309705897148961592L;
    private List<RuleCombinerParameters> ruleCombinerParameters;
    private List<Rule> rules;
    private Collection<VariableDefinition> variableDefinitions;
    private PolicyDefaults defaults;

    public Policy(URI id, Target target, URI combiningAlgId, List<Rule> rules) {
        super(id, target, combiningAlgId);
        this.rules = rules != null ? Collections.unmodifiableList(rules) : null;
    }

    public Policy(URI id, Target target, URI combiningAlgId, String description, List<Rule> rules) {
        super(id, target, combiningAlgId, description);
        this.rules = rules != null ? Collections.unmodifiableList(rules) : null;
    }

    public Policy(URI id, Target target, URI combiningAlgId, String description, String version, List<Rule> rules) {
        super(id, target, combiningAlgId, description, version);
        this.rules = rules != null ? Collections.unmodifiableList(rules) : null;
    }

    public Policy(URI id, Target target, URI combiningAlgId, String description, String version, PolicyDefaults defaults, List<CombinerParameters> combinerParameters, Obligations obligations, List<Rule> rules) {
        super(id, target, combiningAlgId, description, version, combinerParameters, obligations);
        this.defaults = defaults;
        this.rules = rules != null ? Collections.unmodifiableList(rules) : null;
    }

    public Policy(URI id, Target target, URI combiningAlgId, String description, String version, PolicyDefaults defaults, List<CombinerParameters> combinerParameters, Obligations obligations, List<Rule> rules, List<RuleCombinerParameters> ruleCombinerParameters, Collection<VariableDefinition> variableDefinitions) {
        super(id, target, combiningAlgId, description, version, combinerParameters, obligations);
        this.defaults = defaults;
        this.ruleCombinerParameters = ruleCombinerParameters != null ? Collections.unmodifiableList(ruleCombinerParameters) : null;
        this.rules = rules != null ? Collections.unmodifiableList(rules) : null;
        this.variableDefinitions = variableDefinitions != null ? Collections.unmodifiableCollection(variableDefinitions) : null;
    }

    public Policy(AttributeRegistry registry, Node root) throws DocumentParseException, URISyntaxException {
        super(registry, root, "Policy", "RuleCombiningAlgId");
        this.ruleCombinerParameters = new ArrayList<RuleCombinerParameters>();
        this.rules = new ArrayList<Rule>();
        this.variableDefinitions = new ArrayList<VariableDefinition>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String cname = this.getLocalName(node);
            if (cname.equals("RuleCombinerParameters")) {
                this.ruleCombinerParameters.add(new RuleCombinerParameters(registry, node));
                continue;
            }
            if (cname.equals("Rule")) {
                this.rules.add(new Rule(registry, node));
                continue;
            }
            if (cname.equals("VariableDefinition")) {
                this.variableDefinitions.add(new VariableDefinition(registry, node));
                continue;
            }
            if (!cname.equals("PolicyDefaults")) continue;
            this.defaults = new PolicyDefaults(node);
        }
        this.ruleCombinerParameters = this.ruleCombinerParameters.isEmpty() ? null : Collections.unmodifiableList(this.ruleCombinerParameters);
        this.rules = this.rules.isEmpty() ? null : Collections.unmodifiableList(this.rules);
        this.variableDefinitions = this.variableDefinitions.isEmpty() ? null : Collections.unmodifiableCollection(this.variableDefinitions);
    }

    @Override
    protected String getPolicyPrefix() {
        return "Policy";
    }

    @Override
    protected String getCombiningName() {
        return "RuleCombiningAlgId";
    }

    @Override
    public IdReference getReference() {
        return new PolicyIdReference(this.getId(), this.getVersion());
    }

    @Override
    public String getElementName() {
        return "Policy";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        this.encodeDescription(ps);
        if (this.defaults != null) {
            this.defaults.encode(nsMap, ps);
        }
        this.encodeTarget(nsMap, ps);
        this.encodeCombinerParameters(nsMap, ps);
        if (this.ruleCombinerParameters != null) {
            for (RuleCombinerParameters cp : this.ruleCombinerParameters) {
                cp.encode(nsMap, ps);
            }
        }
        if (this.variableDefinitions != null) {
            for (VariableDefinition vd : this.variableDefinitions) {
                vd.encode(nsMap, ps);
            }
        }
        if (this.rules != null) {
            for (Rule r : this.rules) {
                r.encode(nsMap, ps);
            }
        }
        this.encodeObligations(nsMap, ps);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof Policy)) {
            return false;
        }
        Policy o = (Policy)other;
        return CollectionUtil.equals(this.ruleCombinerParameters, o.ruleCombinerParameters) && CollectionUtil.equals(this.rules, o.rules) && CollectionUtil.equals(this.variableDefinitions, o.variableDefinitions) && (this.defaults == o.defaults || this.defaults != null && this.defaults.equals(o.defaults));
    }

    @Override
    public int internalHashCode() {
        int result = super.internalHashCode();
        result = HashCodeUtil.hash((int)result, this.ruleCombinerParameters);
        result = HashCodeUtil.hash((int)result, this.rules);
        result = HashCodeUtil.hash((int)result, this.variableDefinitions);
        result = HashCodeUtil.hash((int)result, (Object)this.defaults);
        return result;
    }

    public PolicyDefaults getDefaults() {
        return this.defaults;
    }

    public List<RuleCombinerParameters> getRuleCombinerParameters() {
        return this.ruleCombinerParameters;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Collection<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }
}

