/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import com.bea.common.security.xacml.policy.ResourceMatch;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
extends PolicySchemaObject {
    private static final long serialVersionUID = 9115133257858295123L;
    private List<ResourceMatch> matches;

    public Resource(List<ResourceMatch> matches) {
        this.matches = matches != null ? Collections.unmodifiableList(matches) : null;
    }

    public Resource(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<ResourceMatch> matches = new ArrayList<ResourceMatch>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("ResourceMatch")) continue;
            matches.add(new ResourceMatch(registry, node));
        }
        this.matches = Collections.unmodifiableList(matches);
    }

    @Override
    public String getElementName() {
        return "Resource";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.matches != null) {
            for (ResourceMatch m : this.matches) {
                m.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Resource o = (Resource)other;
        return CollectionUtil.equals(this.matches, o.matches);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.matches);
        return result;
    }

    public List<ResourceMatch> getMatches() {
        return this.matches;
    }
}

