/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Condition;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import com.bea.common.security.xacml.policy.Target;
import java.io.PrintStream;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends PolicySchemaObject {
    private static final long serialVersionUID = 1790096905544252513L;
    public static final String PERMIT = "Permit";
    public static final String DENY = "Deny";
    private String description;
    private Target target;
    private Condition condition;
    private String ruleId;
    private boolean isEffectPermit;

    public Rule(String ruleId, boolean isEffectPermit) {
        this(ruleId, isEffectPermit, (String)null);
    }

    public Rule(String ruleId, boolean isEffectPermit, String description) {
        this(ruleId, isEffectPermit, null, null, description);
    }

    public Rule(String ruleId, boolean isEffectPermit, Target target) {
        this(ruleId, isEffectPermit, target, null, null);
    }

    public Rule(String ruleId, boolean isEffectPermit, Condition condition) {
        this(ruleId, isEffectPermit, null, condition, null);
    }

    public Rule(String ruleId, boolean isEffectPermit, Target target, Condition condition) {
        this(ruleId, isEffectPermit, target, condition, null);
    }

    public Rule(String ruleId, boolean isEffectPermit, Target target, Condition condition, String description) {
        this.ruleId = ruleId;
        this.isEffectPermit = isEffectPermit;
        this.target = target;
        this.condition = condition;
        this.description = description;
    }

    public Rule(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        this.ruleId = attrs.getNamedItem("RuleId").getNodeValue();
        this.isEffectPermit = PERMIT.equals(attrs.getNamedItem("Effect").getNodeValue());
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = this.getLocalName(child);
            if (cname.equals("Description")) {
                this.description = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                this.target = new Target(registry, child);
                continue;
            }
            if (!cname.equals("Condition")) continue;
            this.condition = new Condition(registry, child);
        }
    }

    @Override
    public String getElementName() {
        return "Rule";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        ps.print(" RuleId=\"");
        ps.print(this.ruleId);
        ps.print("\"");
        ps.print(" Effect=\"");
        ps.print(this.isEffectPermit ? PERMIT : DENY);
        ps.print("\"");
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.description != null) {
            ps.print("<Description>");
            ps.print(this.description);
            ps.print("</Descripton>");
        }
        if (this.target != null) {
            this.target.encode(nsMap, ps);
        }
        if (this.condition != null) {
            this.condition.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rule)) {
            return false;
        }
        Rule o = (Rule)other;
        return (this.target == o.target || this.target != null && this.target.equals(o.target)) && (this.condition == o.condition || this.condition != null && this.condition.equals(o.condition)) && (this.ruleId == o.ruleId || this.ruleId != null && this.ruleId.equals(o.ruleId)) && this.isEffectPermit == o.isEffectPermit;
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.target);
        result = HashCodeUtil.hash((int)result, (Object)this.condition);
        result = HashCodeUtil.hash((int)result, (Object)this.ruleId);
        result = HashCodeUtil.hash((int)result, (boolean)this.isEffectPermit);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public boolean isEffectPermit() {
        return this.isEffectPermit;
    }
}

