/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import com.bea.common.security.xacml.policy.SubjectMatch;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subject
extends PolicySchemaObject {
    private static final long serialVersionUID = -2675029937945117521L;
    private List<SubjectMatch> matches;

    public Subject(List<SubjectMatch> matches) {
        this.matches = matches != null ? Collections.unmodifiableList(matches) : null;
    }

    public Subject(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<SubjectMatch> matches = new ArrayList<SubjectMatch>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("SubjectMatch")) continue;
            matches.add(new SubjectMatch(registry, node));
        }
        this.matches = Collections.unmodifiableList(matches);
    }

    @Override
    public String getElementName() {
        return "Subject";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.matches != null) {
            for (SubjectMatch m : this.matches) {
                m.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Subject)) {
            return false;
        }
        Subject o = (Subject)other;
        return CollectionUtil.equals(this.matches, o.matches);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.matches);
        return result;
    }

    public List<SubjectMatch> getMatches() {
        return this.matches;
    }
}

