/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.response;

import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.json.JsonValue;
import com.bettercloud.vault.response.VaultResponse;
import com.bettercloud.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class LogicalResponse
extends VaultResponse {
    private Map<String, String> data = new HashMap<String, String>();
    private String leaseId;
    private Boolean renewable;
    private Long leaseDuration;

    public LogicalResponse(RestResponse restResponse, int retries, Logical.logicalOperations operation) {
        super(restResponse, retries);
        this.parseMetadataFields();
        this.parseResponseData(operation);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public Boolean getRenewable() {
        return this.renewable;
    }

    public Long getLeaseDuration() {
        return this.leaseDuration;
    }

    private void parseMetadataFields() {
        try {
            String jsonString = new String(this.getRestResponse().getBody(), StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            this.leaseId = jsonObject.get("lease_id").asString();
            this.renewable = jsonObject.get("renewable").asBoolean();
            this.leaseDuration = jsonObject.get("lease_duration").asLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseResponseData(Logical.logicalOperations operation) {
        try {
            String jsonString = new String(this.getRestResponse().getBody(), StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            if (operation.equals((Object)Logical.logicalOperations.readV2)) {
                jsonObject = jsonObject.get("data").asObject();
            }
            this.data = new HashMap<String, String>();
            for (JsonObject.Member member : jsonObject.get("data").asObject()) {
                JsonValue jsonValue = member.getValue();
                if (jsonValue == null || jsonValue.isNull()) continue;
                if (jsonValue.isString()) {
                    this.data.put(member.getName(), jsonValue.asString());
                    continue;
                }
                this.data.put(member.getName(), jsonValue.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

