/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.predicate;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.predicate.AbstractPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompoundPredicate
extends AbstractPredicate {
    private final List<Predicate> children;
    private final BooleanOperator operator;

    public CompoundPredicate(BooleanOperator operator) {
        this(operator, new ArrayList<Predicate>());
    }

    public CompoundPredicate(BooleanOperator operator, Predicate ... children) {
        super(false);
        this.operator = operator;
        this.children = new ArrayList<Predicate>(Arrays.asList(children));
    }

    public CompoundPredicate(BooleanOperator operator, List<Predicate> children) {
        super(false);
        this.operator = operator;
        this.children = children;
    }

    public CompoundPredicate(BooleanOperator operator, List<Predicate> children, boolean negated) {
        super(negated);
        this.operator = operator;
        this.children = children;
    }

    public List<Predicate> getChildren() {
        return this.children;
    }

    public BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public CompoundPredicate copy(ExpressionCopyContext copyContext) {
        ArrayList<Predicate> clonedChildren = new ArrayList<Predicate>(this.children.size());
        for (Predicate child : this.children) {
            clonedChildren.add(child.copy(copyContext));
        }
        return new CompoundPredicate(this.operator, clonedChildren, this.negated);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompoundPredicate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompoundPredicate that = (CompoundPredicate)o;
        if (this.children != null ? !this.children.equals(that.children) : that.children != null) {
            return false;
        }
        return this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        return result;
    }

    public static enum BooleanOperator {
        AND,
        OR;


        public BooleanOperator invert() {
            if (this == AND) {
                return OR;
            }
            return AND;
        }
    }
}

