/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.querydsl;

import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

class HintsAccessor {
    private static final Field HINTS_FIELD;
    private static final Logger LOG;
    private static final Method ENTRIES_METHOD;

    private HintsAccessor() {
    }

    static Iterable<Map.Entry<String, Object>> getHints(AbstractJPAQuery<?, ?> query) {
        try {
            Object hints = HINTS_FIELD.get(query);
            if (hints instanceof Map) {
                return ((Map)hints).entrySet();
            }
            if (ENTRIES_METHOD != null) {
                return (Iterable)ENTRIES_METHOD.invoke(hints, new Object[0]);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Method getEntriesMethod() {
        try {
            return Class.forName("com.google.common.collect.Multimap").getMethod("entries", new Class[0]);
        }
        catch (Exception e) {
            LOG.fine("Could not load Multimap.entries() accessor for query hints");
            return null;
        }
    }

    static {
        LOG = Logger.getLogger(HintsAccessor.class.getName());
        ENTRIES_METHOD = HintsAccessor.getEntriesMethod();
        try {
            HINTS_FIELD = AbstractJPAQuery.class.getDeclaredField("hints");
            HINTS_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Cannot initialize hints accessor", e);
        }
    }
}

