/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.interfaces.IAuthDataController;
import com.box.boxjavalibv2.requests.requestobjects.BoxOAuthRequestObject;

public class OAuthDataController
implements IAuthDataController {
    private static final int WAIT = 100;
    private static final int WAIT_TIME_OUT = 60000;
    private final BoxClient mClient;
    private final String mClientId;
    private final String mClientSecret;
    private String mDeviceId = null;
    private String mDeviceName = null;
    private volatile BoxOAuthToken mOAuthToken;
    private volatile OAuthTokenState mTokenState = OAuthTokenState.PRE_CREATION;
    private boolean mAutoRefresh;
    private int mWaitTimeOut = 60000;
    private volatile boolean locked = false;
    private OAuthRefreshListener refreshListener;

    public OAuthDataController(BoxClient boxClient, String clientId, String clientSecret, boolean autoRefresh) {
        this.mClient = boxClient;
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mAutoRefresh = autoRefresh;
    }

    public void setAutoRefreshOAuth(boolean autoRefresh) {
        this.mAutoRefresh = autoRefresh;
    }

    public void setWaitTimeOut(int timeout) {
        this.mWaitTimeOut = timeout;
    }

    public String getScheme() {
        return this.mClient.getConfig().getOAuthUrlScheme();
    }

    public String getAuthority() {
        return this.mClient.getConfig().getOAuthUrlAuthority();
    }

    public String getUrlPath() {
        return this.mClient.getConfig().getOAuthWebUrlPath();
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public void setOAuthData(BoxOAuthToken token) {
        this.mOAuthToken = token;
    }

    public void setDeviceId(String deviceId) {
        this.mDeviceId = deviceId;
    }

    public void setDeviceName(String deviceName) {
        this.mDeviceName = deviceName;
    }

    public OAuthTokenState getTokenState() {
        return this.mTokenState;
    }

    public void setTokenState(OAuthTokenState tokenState) {
        this.mTokenState = tokenState;
    }

    public void initialize() {
        this.setTokenState(OAuthTokenState.AVAILABLE);
        this.unlock();
    }

    @Override
    public BoxOAuthToken getAuthData() throws AuthFatalFailureException {
        int[] num = new int[]{0};
        return this.getAuthData(num);
    }

    @Override
    public void refresh() throws AuthFatalFailureException {
        if (!this.getAndSetLock(true)) {
            this.getAuthData();
        } else {
            if (this.getTokenState() == OAuthTokenState.FAIL || !this.mAutoRefresh) {
                this.setTokenState(OAuthTokenState.FAIL);
                throw new AuthFatalFailureException(true);
            }
            this.doRefresh();
        }
    }

    private BoxOAuthToken getAuthData(int[] numRetry) throws AuthFatalFailureException {
        int num = numRetry[0];
        if (num * 100 > this.mWaitTimeOut) {
            throw new AuthFatalFailureException();
        }
        if (this.getAndSetLock(false)) {
            return this.mOAuthToken;
        }
        if (this.getTokenState() == OAuthTokenState.FAIL) {
            throw new AuthFatalFailureException();
        }
        this.doWait();
        numRetry[0] = numRetry[0] + 1;
        return this.getAuthData(numRetry);
    }

    public synchronized boolean getAndSetLock(boolean doLock) {
        boolean lockRetrieved = false;
        if (doLock) {
            if (this.locked) {
                lockRetrieved = false;
            } else {
                this.locked = true;
                lockRetrieved = true;
            }
        } else {
            lockRetrieved = !this.locked;
        }
        return lockRetrieved;
    }

    private void unlock() {
        this.locked = false;
    }

    private void doRefresh() throws AuthFatalFailureException {
        this.setTokenState(OAuthTokenState.REFRESHING);
        try {
            BoxOAuthRequestObject requestObj = BoxOAuthRequestObject.refreshOAuthRequestObject(this.mOAuthToken.getRefreshToken(), this.mClientId, this.mClientSecret);
            requestObj.put("device_id", this.mDeviceId);
            requestObj.put("device_name", this.mDeviceName);
            this.mOAuthToken = this.mClient.getOAuthManager().refreshOAuth(requestObj);
            this.setTokenState(OAuthTokenState.AVAILABLE);
            if (this.refreshListener != null) {
                this.refreshListener.onRefresh(this.mOAuthToken);
            }
        }
        catch (Exception e) {
            this.setTokenState(OAuthTokenState.FAIL);
            throw new AuthFatalFailureException(true);
        }
        finally {
            this.unlock();
        }
    }

    private void doWait() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addOAuthRefreshListener(OAuthRefreshListener listener) {
        this.refreshListener = listener;
    }

    public static enum OAuthTokenState {
        PRE_CREATION,
        AVAILABLE,
        REFRESHING,
        FAIL;

    }
}

