/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.dao;

import com.box.boxjavalibv2.interfaces.IBoxParcelWrapper;
import com.box.boxjavalibv2.interfaces.IBoxParcelable;
import com.box.boxjavalibv2.jsonentities.DefaultJSONStringEntity;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class BoxObject
extends DefaultJSONStringEntity
implements IBoxParcelable {
    private final Map<String, Object> extraMap = new HashMap<String, Object>();
    private final Map<String, Object> map = new HashMap<String, Object>();

    public BoxObject() {
    }

    public BoxObject(Map<String, Object> map) {
        BoxObject.cloneMap(this.map, map);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BoxObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BoxObject bObj = (BoxObject)obj;
        return ((Object)this.map).equals(bObj.map) && ((Object)this.extraMap).equals(bObj.extraMap);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.map).append(this.extraMap).toHashCode();
    }

    public BoxObject(BoxObject obj) {
        BoxObject.cloneMap(this.map, obj.map);
        BoxObject.cloneMap(this.extraMap, obj.extraMap);
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public Object getExtraData(String key) {
        return this.extraMap.get(key);
    }

    @JsonAnyGetter
    public Map<String, Object> properties() {
        return this.extraMap;
    }

    public boolean contains(String key) {
        return this.map.containsKey(key) || this.extraMap.containsKey(key);
    }

    @JsonAnySetter
    public void handleUnknown(String key, Object value) {
        if (value instanceof String) {
            this.extraMap.put(key, value);
        }
    }

    @Override
    public void writeToParcel(IBoxParcelWrapper parcelWrapper, int flags) {
        parcelWrapper.writeMap(this.map);
        parcelWrapper.writeMap(this.extraMap);
    }

    public BoxObject(IBoxParcelWrapper in) {
        in.readMap(this.map);
        in.readMap(this.extraMap);
    }

    private static void cloneMap(Map<String, Object> destination, Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof BoxObject) {
                try {
                    destination.put(entry.getKey(), value.getClass().getConstructor(value.getClass()).newInstance(value));
                }
                catch (Exception e) {}
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList<Object> list = new ArrayList<Object>();
                BoxObject.cloneArrayList(list, (ArrayList)value);
                destination.put(entry.getKey(), list);
                continue;
            }
            destination.put(entry.getKey(), value);
        }
    }

    private static void cloneArrayList(ArrayList<Object> destination, ArrayList<Object> source) {
        for (Object obj : source) {
            if (obj instanceof BoxObject) {
                try {
                    destination.add(obj.getClass().getConstructor(obj.getClass()).newInstance(obj));
                }
                catch (Exception e) {}
                continue;
            }
            destination.add(obj);
        }
    }
}

