/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.dao;

import com.box.boxjavalibv2.interfaces.IBoxType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum BoxResourceType implements IBoxType
{
    ITEM,
    ITEMS,
    FILE,
    FILES,
    WEB_LINK,
    WEB_LINKS,
    PREVIEW,
    FOLDER,
    USER,
    USERS,
    GROUP,
    COMMENT,
    COMMENTS,
    FILE_VERSION,
    FILE_VERSIONS,
    COLLABORATION,
    COLLABORATIONS,
    EMAIL_ALIAS,
    EMAIL_ALIASES,
    OAUTH_DATA,
    ERROR,
    EVENT,
    EVENTS,
    UPDATES,
    REALTIME_SERVER,
    LOCK,
    SERVICE_ACTION,
    ADMIN_SETTINGS;

    private static final Map<BoxResourceType, String> typeToLowercaseString;
    private static final Map<String, BoxResourceType> lowercaseStringToType;

    public String toString() {
        return typeToLowercaseString.get(this);
    }

    public String toPluralString() {
        return this.toString() + "s";
    }

    public static BoxResourceType getTypeFromLowercaseString(String string) {
        return lowercaseStringToType.get(string);
    }

    static {
        typeToLowercaseString = new HashMap<BoxResourceType, String>();
        lowercaseStringToType = new HashMap<String, BoxResourceType>();
        for (BoxResourceType type : BoxResourceType.values()) {
            String str = type.name().toLowerCase(Locale.ENGLISH);
            typeToLowercaseString.put(type, str);
            lowercaseStringToType.put(str, type);
        }
    }
}

