/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxEmailAlias;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.dao.BoxUser;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateEmailAliasRequest;
import com.box.boxjavalibv2.requests.CreateEnterpriseUserRequest;
import com.box.boxjavalibv2.requests.DeleteEmailAliasRequest;
import com.box.boxjavalibv2.requests.GetAllUsersInEnterpriseRequest;
import com.box.boxjavalibv2.requests.GetCurrentUserRequest;
import com.box.boxjavalibv2.requests.GetEmailAliasesRequest;
import com.box.boxjavalibv2.requests.MoveFolderToAnotherUserRequest;
import com.box.boxjavalibv2.requests.UpdateUserLoginRequest;
import com.box.boxjavalibv2.requests.UpdateUserRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxUserRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxResourceManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import java.util.ArrayList;
import java.util.List;

public final class BoxUsersManager
extends BoxResourceManager {
    public BoxUsersManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public BoxUser getCurrentUser(BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetCurrentUserRequest request = new GetCurrentUserRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxUser)this.getResponseAndParseAndTryCast(request, BoxResourceType.USER, this.getJSONParser());
    }

    public List<BoxUser> getAllEnterpriseUser(BoxDefaultRequestObject requestObject, String filterTerm) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetAllUsersInEnterpriseRequest request = new GetAllUsersInEnterpriseRequest(this.getConfig(), this.getJSONParser(), requestObject, filterTerm);
        BoxCollection collection = (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.USERS, this.getJSONParser());
        return BoxUsersManager.getUsers(collection);
    }

    public BoxFolder moveFolderToAnotherUser(String userId, String folderId, BoxUserRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        MoveFolderToAnotherUserRequest request = new MoveFolderToAnotherUserRequest(this.getConfig(), this.getJSONParser(), userId, folderId, requestObject);
        return (BoxFolder)this.getResponseAndParseAndTryCast(request, BoxResourceType.FOLDER, this.getJSONParser());
    }

    public BoxUser createEnterpriseUser(BoxUserRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateEnterpriseUserRequest request = new CreateEnterpriseUserRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxUser)this.getResponseAndParseAndTryCast(request, BoxResourceType.USER, this.getJSONParser());
    }

    public BoxUser updateUserInformaiton(String userId, BoxUserRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        UpdateUserRequest request = new UpdateUserRequest(this.getConfig(), this.getJSONParser(), userId, requestObject);
        return (BoxUser)this.getResponseAndParseAndTryCast(request, BoxResourceType.USER, this.getJSONParser());
    }

    public List<BoxEmailAlias> getEmailAliases(String userId, BoxDefaultRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        GetEmailAliasesRequest request = new GetEmailAliasesRequest(this.getConfig(), this.getJSONParser(), userId, requestObject);
        BoxCollection collection = (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.EMAIL_ALIASES, this.getJSONParser());
        return BoxUsersManager.getEmailAliases(collection);
    }

    public BoxEmailAlias addEmailAlias(String userId, BoxUserRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        CreateEmailAliasRequest request = new CreateEmailAliasRequest(this.getConfig(), this.getJSONParser(), userId, requestObject);
        return (BoxEmailAlias)this.getResponseAndParseAndTryCast(request, BoxResourceType.EMAIL_ALIAS, this.getJSONParser());
    }

    public void deleteEmailAlias(String userId, String emailId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteEmailAliasRequest request = new DeleteEmailAliasRequest(this.getConfig(), this.getJSONParser(), userId, emailId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    public BoxUser updateUserPrimaryLogin(String userId, BoxUserRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        UpdateUserLoginRequest request = new UpdateUserLoginRequest(this.getConfig(), this.getJSONParser(), userId, requestObject);
        return (BoxUser)this.getResponseAndParseAndTryCast(request, BoxResourceType.USER, this.getJSONParser());
    }

    public static List<BoxUser> getUsers(BoxCollection collection) {
        ArrayList<BoxUser> users = new ArrayList<BoxUser>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxUser)) continue;
            users.add((BoxUser)object);
        }
        return users;
    }

    public static List<BoxEmailAlias> getEmailAliases(BoxCollection collection) {
        ArrayList<BoxEmailAlias> aliases = new ArrayList<BoxEmailAlias>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxEmailAlias)) continue;
            aliases.add((BoxEmailAlias)object);
        }
        return aliases;
    }
}

