/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionFactory;
import com.brein.time.timeintervals.collections.PersistableIntervalCollectionFactory;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;

public class CaffeineIntervalCollectionFactory
extends PersistableIntervalCollectionFactory
implements Externalizable {
    private transient LoadingCache<String, IntervalCollection> cache;
    private long cacheSize;
    private long expire;
    private TimeUnit timeUnit;

    public CaffeineIntervalCollectionFactory() {
    }

    public CaffeineIntervalCollectionFactory(long cacheSize, long expire, TimeUnit timeUnit, IntervalCollectionFactory wrappedFactory) {
        super(wrappedFactory);
        this.cache = this.createCache(cacheSize, expire, timeUnit);
    }

    protected LoadingCache<String, IntervalCollection> createCache(long cacheSize, long expire, TimeUnit timeUnit) {
        this.cacheSize = cacheSize;
        this.expire = expire;
        this.timeUnit = timeUnit;
        return Caffeine.newBuilder().maximumSize(cacheSize).expireAfterAccess(expire, timeUnit).build(x$0 -> super.load((String)x$0));
    }

    @Override
    public IntervalCollection load(String key) {
        IntervalCollection result = (IntervalCollection)this.cache.get((Object)key);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Loading instance from cache '" + key + "': " + result));
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.cacheSize);
        out.writeLong(this.expire);
        out.writeObject((Object)this.timeUnit);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        long cacheSize = in.readLong();
        long expire = in.readLong();
        TimeUnit timeUnit = (TimeUnit)((Object)TimeUnit.class.cast(in.readObject()));
        this.cache = this.createCache(cacheSize, expire, timeUnit);
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public void clear() {
        this.cache.cleanUp();
    }
}

