/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.filters.IntervalFilters;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import com.brein.time.timeintervals.intervals.IInterval;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IntervalCollection
extends Iterable<IInterval> {
    public boolean add(IInterval var1);

    public boolean remove(IInterval var1);

    public boolean isEmpty();

    public int size();

    default public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp) {
        return this.find(interval, cmp, IntervalFilters::equal);
    }

    default public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp, IntervalFilter filter) {
        return this.stream().filter(i -> filter.match(cmp, (IInterval)i, interval)).collect(Collectors.toList());
    }

    default public Stream<IInterval> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public String getUniqueIdentifier() {
        if (this.isEmpty()) {
            return null;
        }
        IInterval interval = (IInterval)this.iterator().next();
        return interval.getUniqueIdentifier();
    }
}

