/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionEventType;
import com.brein.time.timeintervals.intervals.IInterval;

public class IntervalCollectionEvent {
    private final String key;
    private final IInterval interval;
    private final IntervalCollection collection;
    private final IntervalCollectionEventType eventType;

    public IntervalCollectionEvent(IInterval interval, IntervalCollection collection, IntervalCollectionEventType eventType) {
        this(interval.getUniqueIdentifier(), interval, collection, eventType);
    }

    public IntervalCollectionEvent(String key, IInterval interval, IntervalCollection collection, IntervalCollectionEventType eventType) {
        this.key = key;
        this.interval = interval;
        this.collection = collection;
        this.eventType = eventType;
    }

    public String getKey() {
        return this.key;
    }

    public IntervalCollection getCollection() {
        return this.collection;
    }

    public IInterval getInterval() {
        return this.interval;
    }

    public IntervalCollectionEventType getEventType() {
        return this.eventType;
    }

    public String toString() {
        return String.format("%s: %s (%s)", new Object[]{this.eventType, this.key, this.interval});
    }
}

