/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionPersistor;
import com.brein.time.timeintervals.collections.ShallowIntervalCollection;
import com.brein.time.timeintervals.intervals.IInterval;
import java.io.Serializable;

@FunctionalInterface
public interface IntervalCollectionFactory
extends Serializable {
    public static IntervalCollection shallow() {
        return ShallowIntervalCollection.SHALLOW_COLLECTION;
    }

    public static IntervalCollection shallow(String key) {
        return IntervalCollectionFactory.shallow();
    }

    public IntervalCollection load(String var1);

    default public boolean useWeakReferences() {
        return false;
    }

    default public void usePersistor(IntervalCollectionPersistor persistor) {
        if (persistor != null) {
            throw new IllegalConfiguration("The factory does not support the usage of any persistor.");
        }
    }

    default public String getIntervalKey(IInterval interval) {
        return interval.getUniqueIdentifier();
    }
}

