/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionEvent;
import com.brein.time.timeintervals.collections.IntervalCollectionFactory;
import com.brein.time.timeintervals.collections.IntervalCollectionObserver;
import com.brein.time.timeintervals.collections.IntervalCollectionPersistor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PersistableIntervalCollectionFactory
implements IntervalCollectionFactory,
IntervalCollectionObserver,
Externalizable {
    private transient IntervalCollectionPersistor persistor;
    private IntervalCollectionFactory wrappedFactory;

    public PersistableIntervalCollectionFactory() {
    }

    public PersistableIntervalCollectionFactory(IntervalCollectionFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
    }

    @Override
    public void remove(IntervalCollectionEvent event) {
        if (this.persistor != null) {
            this.persistor.remove(event);
        }
    }

    @Override
    public void upsert(IntervalCollectionEvent event) {
        if (this.persistor != null) {
            this.persistor.upsert(event);
        }
    }

    @Override
    public IntervalCollection load(String key) {
        IntervalCollection result = this.persistor == null ? null : this.persistor.load(key);
        if (result == null) {
            result = this.wrappedFactory.load(key);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Using created collection for '" + key + "': " + result));
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Using persisted collection for '" + key + "': " + result));
        }
        return result;
    }

    @Override
    public boolean useWeakReferences() {
        return true;
    }

    @Override
    public void usePersistor(IntervalCollectionPersistor persistor) {
        this.persistor = persistor;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.persistor != null && LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Please make sure that the persistor '" + this.persistor.getClass() + "' " + "will be re-initialized prior to using the persisted instance."));
        }
        out.writeObject(this.wrappedFactory);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.wrappedFactory = (IntervalCollectionFactory)IntervalCollectionFactory.class.cast(in.readObject());
    }
}

