/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import com.brein.time.timeintervals.intervals.IInterval;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class UnmodifiableIntervalCollection
implements IntervalCollection {
    private final transient IntervalCollection wrappedCollection;

    public UnmodifiableIntervalCollection(IntervalCollection wrappedCollection) {
        this.wrappedCollection = wrappedCollection;
    }

    @Override
    public boolean add(IInterval interval) {
        throw new IllegalStateException("Collection is unmodifiable.");
    }

    @Override
    public boolean remove(IInterval interval) {
        throw new IllegalStateException("Collection is unmodifiable.");
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedCollection.isEmpty();
    }

    @Override
    public int size() {
        return this.wrappedCollection.size();
    }

    @Override
    public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp) {
        return this.wrappedCollection.find(interval, cmp);
    }

    @Override
    public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp, IntervalFilter filter) {
        return this.wrappedCollection.find(interval, cmp, filter);
    }

    @Override
    public Stream<IInterval> stream() {
        return this.wrappedCollection.stream();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.wrappedCollection.getUniqueIdentifier();
    }

    @Override
    public Iterator<IInterval> iterator() {
        final Iterator it = this.wrappedCollection.iterator();
        return new Iterator<IInterval>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public IInterval next() {
                return (IInterval)it.next();
            }
        };
    }
}

