/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import com.brein.time.timeintervals.indexes.IntervalTreeNode;
import com.brein.time.timeintervals.indexes.IntervalTreeNodeChildType;

public class IntervalTreeNodeContext {
    protected IntervalTreeNode left;
    protected IntervalTreeNode right;
    private transient IntervalTreeNode parent;

    public IntervalTreeNodeContext() {
    }

    public IntervalTreeNodeContext(IntervalTreeNode parent, IntervalTreeNode left, IntervalTreeNode right) {
        this();
        this.parent = parent;
        this.left = left;
        this.right = right;
    }

    public IntervalTreeNodeContext(IntervalTreeNode node) {
        this(node.getParent(), node.getLeft(), node.getRight());
    }

    public IntervalTreeNode getParent() {
        return this.parent;
    }

    public void setParent(IntervalTreeNode parent) {
        this.parent = parent;
    }

    public IntervalTreeNode getChild(IntervalTreeNodeChildType childType) {
        if (childType.equals((Object)IntervalTreeNodeChildType.LEFT)) {
            return this.getLeft();
        }
        if (childType.equals((Object)IntervalTreeNodeChildType.RIGHT)) {
            return this.getRight();
        }
        return null;
    }

    public IntervalTreeNode getLeft() {
        return this.left;
    }

    public void setLeft(IntervalTreeNode left) {
        this.left = left;
    }

    public IntervalTreeNode getRight() {
        return this.right;
    }

    public void setRight(IntervalTreeNode right) {
        this.right = right;
    }

    public boolean hasLeft() {
        return this.left != null;
    }

    public boolean hasRight() {
        return this.right != null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasChild(IntervalTreeNodeChildType childType) {
        if (childType.equals((Object)IntervalTreeNodeChildType.LEFT)) {
            return this.hasLeft();
        }
        if (childType.equals((Object)IntervalTreeNodeChildType.RIGHT)) {
            return this.hasRight();
        }
        return false;
    }

    public boolean isChild(IntervalTreeNode node) {
        return this.left == node || this.right == node;
    }

    public boolean isLeaf() {
        return !this.hasLeft() && !this.hasRight();
    }

    public boolean isSingleParent() {
        return this.hasLeft() ^ this.hasRight();
    }

    public boolean isFullParent() {
        return this.hasLeft() && this.hasRight();
    }

    public IntervalTreeNode getSingleChild() {
        if (!this.isSingleParent()) {
            throw new IllegalStateException("Cannot retrieve single child from not single parent, validate with 'isSingleParent'");
        }
        return this.hasLeft() ? this.getLeft() : this.getRight();
    }

    public void setContext(IntervalTreeNodeContext ctx) {
        this.setParent(ctx.getParent());
        this.setLeft(ctx.getLeft());
        this.setRight(ctx.getRight());
    }

    public boolean isInContext(IntervalTreeNode node) {
        return this.isChild(node) || this.parent == node;
    }

    public boolean isRoot() {
        return !this.hasParent();
    }

    public String toString() {
        return String.format("P: %s, L: %s, R: %s", this.parent, this.left, this.right);
    }
}

