/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import com.brein.time.timeintervals.indexes.IntervalTreeNode;

public class PositionedNode {
    private final IntervalTreeNode node;
    private final long x;
    private final long y;

    public PositionedNode(IntervalTreeNode node, long x, long y) {
        this.node = node;
        this.x = x;
        this.y = y;
    }

    public static PositionedNode moveUp(IntervalTreeNode parent, PositionedNode child, long offset) {
        long currentX = child.getX();
        for (long i = 0L; i < offset; ++i) {
            currentX = Double.valueOf(Math.floor(0.5 * (double)currentX)).longValue();
        }
        return new PositionedNode(parent, currentX, child.getY() - offset);
    }

    public static PositionedNode moveLeft(IntervalTreeNode left, PositionedNode parent, long offset) {
        long x = Double.valueOf((double)parent.getX() * Math.pow(2.0, offset)).longValue();
        return new PositionedNode(left, x, parent.getY() + offset);
    }

    public static PositionedNode moveRight(IntervalTreeNode right, PositionedNode parent, long offset) {
        long x = Double.valueOf((double)parent.getX() * Math.pow(2.0, offset)).longValue() + offset;
        return new PositionedNode(right, x, parent.getY() + offset);
    }

    public String getId() {
        return this.node.getId();
    }

    public IntervalTreeNode getNode() {
        return this.node;
    }

    public long getX() {
        return this.x;
    }

    public long getY() {
        return this.y;
    }

    public String toString() {
        return String.format("[%d, %d] - %s", this.x, this.y, this.node);
    }
}

