/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.intervals;

import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.exceptions.IllegalTimeInterval;
import com.brein.time.timeintervals.intervals.IInterval;
import com.brein.time.timeintervals.intervals.NumberInterval;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class IdInterval<I extends Comparable<I> & Serializable, T extends Comparable<T> & Serializable>
implements IInterval<T>,
Externalizable {
    private I id;
    private IInterval<T> wrappedInterval;

    public IdInterval() {
    }

    public IdInterval(I id, T start, T end) {
        if (start == null && end == null) {
            throw new IllegalTimeInterval("Please use the constructor with specified clazz, if start and end are null.");
        }
        Class<?> clazz = start == null ? end.getClass() : start.getClass();
        this.init(id, this.createInterval(start, end, clazz));
    }

    public IdInterval(I id, T start, T end, Class<T> clazz) {
        this.init(id, this.createInterval(start, end, clazz));
    }

    public IdInterval(I id, IInterval<T> wrappedInterval) {
        this.init(id, wrappedInterval);
    }

    protected IInterval<T> createInterval(T start, T end, Class<T> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            Class<T> numberClazz = clazz;
            return new NumberInterval<Number>(numberClazz, (Number)numberClazz.cast(start), (Number)numberClazz.cast(end));
        }
        throw new IllegalConfiguration("There is currently no default implementation available for the specified clazz '" + clazz + "', you can override the `createInterval` method, if an interval-type is " + "known.");
    }

    protected void init(I id, IInterval<T> wrappedInterval) {
        this.id = id;
        this.wrappedInterval = wrappedInterval;
    }

    public I getId() {
        return this.id;
    }

    @Override
    public T getNormStart() {
        return this.wrappedInterval.getNormStart();
    }

    @Override
    public T getNormEnd() {
        return this.wrappedInterval.getNormEnd();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.wrappedInterval.getUniqueIdentifier();
    }

    @Override
    public int compareTo(IInterval i) {
        int cmp = this.wrappedInterval.compareTo(i);
        if (cmp == 0) {
            if (i instanceof IdInterval) {
                return this.compareId((IdInterval)IdInterval.class.cast(i));
            }
            return this.getClass().getName().compareTo(i.getClass().getName());
        }
        return cmp;
    }

    public int compareId(IdInterval iId) {
        if (this.id == null && iId == null) {
            return 0;
        }
        if (this.id == null) {
            return -1;
        }
        if (iId == null) {
            return 1;
        }
        if (this.id.getClass().isInstance(iId.id)) {
            return this.id.compareTo(iId.id);
        }
        return this.id.toString().compareTo(iId.id.toString());
    }

    public <X extends IInterval<T>> X interval() {
        return (X)this.wrappedInterval;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (IInterval.class.isInstance(obj)) {
            return this.compareTo((IInterval)IInterval.class.cast(obj)) == 0;
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%s", this.id, this.wrappedInterval);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.wrappedInterval);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (Comparable)in.readObject();
        this.wrappedInterval = (IInterval)in.readObject();
    }
}

