/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.intervals;

import com.brein.time.exceptions.IllegalTimeInterval;
import com.brein.time.exceptions.IllegalTimePoint;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import com.brein.time.timeintervals.intervals.AllenIntervalRelation;
import com.brein.time.timeintervals.intervals.IInterval;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.log4j.Logger;

public class NumberInterval<T extends Number>
implements IInterval<T>,
Externalizable {
    private static final Logger LOGGER = Logger.getLogger(NumberInterval.class);
    private static final double MAX_DOUBLE = Math.pow(2.0, 54.0) - 2.0;
    private Class clazz;
    private T start;
    private T end;
    private boolean openStart;
    private boolean openEnd;

    public NumberInterval() {
    }

    public NumberInterval(Class<T> clazz, T start, T end) throws IllegalTimeInterval, IllegalTimePoint {
        this(clazz, start, end, false, false);
    }

    public NumberInterval(Class<T> clazz, T start, T end, boolean openStart, boolean openEnd) throws IllegalTimeInterval, IllegalTimePoint {
        this.clazz = clazz;
        this.init(start, end, openStart, openEnd);
    }

    protected void init(Object start, Object end, boolean openStart, boolean openEnd) throws IllegalTimeInterval, IllegalTimePoint {
        this.start = this.validate(start, true);
        this.end = this.validate(end, false);
        this.openStart = openStart;
        this.openEnd = openEnd;
        if (this.compare(this.getNormEnd(), this.getNormStart()) < 0) {
            throw new IllegalTimeInterval("The end value '" + end + "' " + "cannot be smaller than the start value '" + start + "'.");
        }
    }

    protected T validate(Object val, boolean start) throws IllegalTimeInterval, IllegalTimePoint {
        if (val == null) {
            return start ? this.determineMinValue() : this.determineMaxValue();
        }
        Number result = this.clazz.isInstance(val) ? (Number)((Number)this.clazz.cast(val)) : (Number)((Number)IntervalValueComparator.mapNumberValue(val, this.clazz));
        T min = this.determineMinValue();
        T max = this.determineMaxValue();
        if (min.equals(result) || max.equals(result)) {
            throw new IllegalTimeInterval("The minimal and maximal value are reserved.");
        }
        if (this.getNextValue(min).equals(result) || this.getPreviousValue(max).equals(result)) {
            throw new IllegalTimeInterval("The edge values are reserved and cannot be used.");
        }
        if (Double.class.equals((Object)this.clazz)) {
            Double dVal = (Double)Double.class.cast(result);
            if (dVal.equals(Double.NaN)) {
                throw new IllegalTimePoint("The value NaN is a not supported value.");
            }
            if (dVal.equals(Double.NEGATIVE_INFINITY)) {
                return this.determineMinValue();
            }
            if (dVal.equals(Double.POSITIVE_INFINITY)) {
                return this.determineMaxValue();
            }
        } else if (Float.class.equals((Object)this.clazz)) {
            Float fVal = (Float)Float.class.cast(result);
            if (fVal.equals(Float.valueOf(Float.NaN))) {
                throw new IllegalTimePoint("The value NaN is a not supported value.");
            }
            if (fVal.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return this.determineMinValue();
            }
            if (fVal.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return this.determineMaxValue();
            }
        }
        return (T)result;
    }

    protected T determineMaxValue() {
        if (Short.class.equals((Object)this.clazz)) {
            return (T)Short.valueOf((short)Short.MAX_VALUE);
        }
        if (Byte.class.equals((Object)this.clazz)) {
            return (T)Byte.valueOf((byte)127);
        }
        if (Integer.class.equals((Object)this.clazz)) {
            return (T)Integer.valueOf(Integer.MAX_VALUE);
        }
        if (Long.class.equals((Object)this.clazz)) {
            return (T)Long.valueOf(Long.MAX_VALUE);
        }
        if (Float.class.equals((Object)this.clazz)) {
            return (T)Float.valueOf(Float.MAX_VALUE);
        }
        if (Double.class.equals((Object)this.clazz)) {
            return (T)Double.valueOf(Double.MAX_VALUE);
        }
        throw new IllegalArgumentException("The class '" + this.clazz + "' is not supported.");
    }

    protected T determineMinValue() {
        if (Short.class.equals((Object)this.clazz)) {
            return (T)Short.valueOf((short)Short.MIN_VALUE);
        }
        if (Byte.class.equals((Object)this.clazz)) {
            return (T)Byte.valueOf((byte)-128);
        }
        if (Integer.class.equals((Object)this.clazz)) {
            return (T)Integer.valueOf(Integer.MIN_VALUE);
        }
        if (Long.class.equals((Object)this.clazz)) {
            return (T)Long.valueOf(Long.MIN_VALUE);
        }
        if (Float.class.equals((Object)this.clazz)) {
            return (T)Float.valueOf(Float.MIN_VALUE);
        }
        if (Double.class.equals((Object)this.clazz)) {
            return (T)Double.valueOf(Double.MIN_VALUE);
        }
        throw new IllegalArgumentException("The class '" + this.clazz + "' is not supported.");
    }

    protected T getNextValue(T val) {
        if (this.determineMinValue().equals(val) || this.determineMaxValue().equals(val)) {
            return val;
        }
        if (Short.class.equals((Object)this.clazz)) {
            return (T)Short.valueOf((short)((Short)Short.class.cast(val) + 1));
        }
        if (Byte.class.equals((Object)this.clazz)) {
            return (T)Byte.valueOf((byte)((Byte)Byte.class.cast(val) + 1));
        }
        if (Integer.class.equals((Object)this.clazz)) {
            return (T)Integer.valueOf((Integer)Integer.class.cast(val) + 1);
        }
        if (Long.class.equals((Object)this.clazz)) {
            return (T)Long.valueOf((Long)Long.class.cast(val) + 1L);
        }
        if (Float.class.equals((Object)this.clazz)) {
            return (T)Double.valueOf(Math.nextAfter(((Float)Float.class.cast(val)).floatValue(), Double.POSITIVE_INFINITY));
        }
        if (Double.class.equals((Object)this.clazz)) {
            return (T)Double.valueOf(Math.nextAfter((Double)Double.class.cast(val), Double.POSITIVE_INFINITY));
        }
        throw new IllegalArgumentException("The class '" + this.clazz + "' is not supported.");
    }

    protected T getPreviousValue(T val) {
        if (this.determineMinValue().equals(val) || this.determineMaxValue().equals(val)) {
            return val;
        }
        if (Short.class.equals((Object)this.clazz)) {
            return (T)Short.valueOf((short)((Short)Short.class.cast(val) - 1));
        }
        if (Byte.class.equals((Object)this.clazz)) {
            return (T)Byte.valueOf((byte)((Byte)Byte.class.cast(val) - 1));
        }
        if (Integer.class.equals((Object)this.clazz)) {
            return (T)Integer.valueOf((Integer)Integer.class.cast(val) - 1);
        }
        if (Long.class.equals((Object)this.clazz)) {
            return (T)Long.valueOf((Long)Long.class.cast(val) - 1L);
        }
        if (Float.class.equals((Object)this.clazz)) {
            return (T)Double.valueOf(Math.nextAfter(((Float)Float.class.cast(val)).floatValue(), Double.NEGATIVE_INFINITY));
        }
        if (Double.class.equals((Object)this.clazz)) {
            return (T)Double.valueOf(Math.nextAfter((Double)Double.class.cast(val), Double.NEGATIVE_INFINITY));
        }
        throw new IllegalArgumentException("The class '" + this.clazz + "' is not supported.");
    }

    public T getStart() {
        return this.start;
    }

    @Override
    public T getNormStart() {
        return this.norm(this.start, this.openStart, true);
    }

    @Override
    public T getNormEnd() {
        return this.norm(this.end, this.openEnd, false);
    }

    @Override
    public String getUniqueIdentifier() {
        return "[" + this.unique(this.getNormStart()) + "," + this.unique(this.getNormEnd()) + "]";
    }

    public T getEnd() {
        return this.end;
    }

    protected String unique(T value) {
        if (Short.class.equals((Object)this.clazz)) {
            return String.valueOf(((Short)Short.class.cast(value)).longValue());
        }
        if (Byte.class.equals((Object)this.clazz)) {
            return String.valueOf(((Byte)Byte.class.cast(value)).longValue());
        }
        if (Integer.class.equals((Object)this.clazz)) {
            return String.valueOf(((Integer)Integer.class.cast(value)).longValue());
        }
        if (Long.class.equals((Object)this.clazz)) {
            return String.valueOf((Long)Long.class.cast(value));
        }
        if (Float.class.equals((Object)this.clazz)) {
            return this.unique(((Float)Float.class.cast(value)).doubleValue());
        }
        if (Double.class.equals((Object)this.clazz)) {
            return this.unique((Double)Double.class.cast(value));
        }
        throw new IllegalArgumentException("The class '" + this.clazz + "' is not supported.");
    }

    protected String unique(double value) {
        if (MAX_DOUBLE < Math.abs(value)) {
            LOGGER.warn((Object)("Using double values larger than " + this.unique(MAX_DOUBLE)));
        }
        if (value == Math.rint(value)) {
            return String.valueOf(Double.valueOf(value).longValue());
        }
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
        return df.format(value);
    }

    public boolean isOpenStart() {
        return this.openStart;
    }

    public boolean isOpenEnd() {
        return this.openEnd;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public boolean overlaps(IInterval interval) {
        int startCmp = this.compare(this.getNormStart(), interval.getNormEnd());
        if (startCmp > 0) {
            return false;
        }
        if (startCmp == 0) {
            return true;
        }
        return this.compare(this.getNormEnd(), interval.getNormStart()) >= 0;
    }

    public AllenIntervalRelation ir(IInterval interval) {
        return AllenIntervalRelation.determineRelation(this, interval);
    }

    public boolean irOverlaps(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) < 0 && this.compare(interval.getNormStart(), this.getNormEnd()) <= 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) < 0;
    }

    public boolean irIsOverlappedBy(IInterval interval) {
        return this.compare(interval.getNormStart(), this.getNormStart()) < 0 && this.compare(this.getNormStart(), interval.getNormEnd()) <= 0 && this.compare(interval.getNormEnd(), this.getNormEnd()) < 0;
    }

    public boolean irEquals(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) == 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) == 0;
    }

    public boolean irBegins(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) == 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) > 0;
    }

    public boolean irBeginsBy(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) == 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) < 0;
    }

    public boolean irEnds(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) < 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) == 0;
    }

    public boolean irEndsBy(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) > 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) == 0;
    }

    public boolean irBefore(IInterval interval) {
        return this.compare(this.getNormEnd(), interval.getNormStart()) < 0 && !this.irEndsDirectlyBefore(interval);
    }

    public boolean irAfter(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormEnd()) > 0 && !this.irStartsDirectlyBefore(interval);
    }

    public boolean irIncludes(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) < 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) > 0;
    }

    public boolean irIsDuring(IInterval interval) {
        return this.compare(this.getNormStart(), interval.getNormStart()) > 0 && this.compare(this.getNormEnd(), interval.getNormEnd()) < 0;
    }

    public boolean irStartsDirectlyBefore(IInterval interval) {
        return this.compare(interval.getNormEnd(), this.getPreviousValue(this.getNormStart())) == 0;
    }

    public boolean irEndsDirectlyBefore(IInterval interval) {
        return this.compare(this.getNextValue(this.getNormEnd()), interval.getNormStart()) == 0;
    }

    public int hashCode() {
        return this.getUniqueIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NumberInterval) {
            NumberInterval i = (NumberInterval)NumberInterval.class.cast(obj);
            return this.compareTo(i) == 0;
        }
        return false;
    }

    public String toString() {
        return String.format("%s%s, %s%s", this.getStartMarker(), this.getStart(), this.getEnd(), this.getEndMarker());
    }

    protected String getStartMarker() {
        return this.isOpenStart() ? "(" : "[";
    }

    protected String getEndMarker() {
        return this.isOpenEnd() ? ")" : "]";
    }

    @Override
    public int compareTo(IInterval i) {
        int cmpStart = this.compare(this.getNormStart(), i.getNormStart());
        if (cmpStart == 0) {
            return this.compare(this.getNormEnd(), i.getNormEnd());
        }
        return cmpStart;
    }

    public boolean contains(Object value) {
        return this.compare(this.getNormStart(), value) <= 0 && this.compare(this.getNormEnd(), value) >= 0;
    }

    protected T norm(T val, boolean open, boolean start) {
        if (start) {
            return open ? this.getNextValue(val) : val;
        }
        return open ? this.getPreviousValue(val) : val;
    }

    protected int compare(Object o1, Object o2) {
        return IntervalValueComparator.compareNumbers(o1, o2);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.clazz);
        out.writeObject(this.start);
        out.writeObject(this.end);
        out.writeBoolean(this.openStart);
        out.writeBoolean(this.openEnd);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clazz = (Class)Class.class.cast(in.readObject());
        this.start = (Number)this.clazz.cast(in.readObject());
        this.end = (Number)this.clazz.cast(in.readObject());
        this.openStart = in.readBoolean();
        this.openEnd = in.readBoolean();
    }
}

