/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeseries;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class BucketTimeSeriesConfig<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(BucketTimeSeriesConfig.class);
    private static final Set<TimeUnit> SUPPORTED_TIME_UNITS = new HashSet<TimeUnit>();
    private final TimeUnit timeUnit;
    private final int bucketSize;
    private final int timeSeriesSize;
    private final Class<?> bucketContent;
    private final boolean fillNumberWithZero;

    public BucketTimeSeriesConfig(Class<?> bucketContent, TimeUnit timeUnit, int timeSeriesSize) {
        this(bucketContent, timeUnit, timeSeriesSize, 1);
    }

    public BucketTimeSeriesConfig(Class<?> bucketContent, TimeUnit timeUnit, int timeSeriesSize, int bucketSize) {
        this(bucketContent, timeUnit, timeSeriesSize, bucketSize, Number.class.isAssignableFrom(bucketContent));
    }

    public BucketTimeSeriesConfig(Class<?> bucketContent, TimeUnit timeUnit, int timeSeriesSize, int bucketSize, boolean fillNumberWithZero) {
        this.timeUnit = timeUnit;
        this.timeSeriesSize = timeSeriesSize;
        this.bucketSize = bucketSize;
        this.bucketContent = bucketContent;
        this.fillNumberWithZero = fillNumberWithZero;
        if (!SUPPORTED_TIME_UNITS.contains((Object)this.timeUnit)) {
            LOG.warn((Object)("Using a currently unsupported/untested timeUnit '" + (Object)((Object)this.timeUnit) + "' for the buckets."));
        }
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public int getTimeSeriesSize() {
        return this.timeSeriesSize;
    }

    public boolean isFillNumberWithZero() {
        return this.fillNumberWithZero;
    }

    public Class<T> getBucketContent() {
        return this.bucketContent;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeUnit, this.timeSeriesSize, this.bucketSize, this.bucketContent, this.fillNumberWithZero});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (BucketTimeSeriesConfig.class.equals(obj.getClass())) {
            BucketTimeSeriesConfig btsc = (BucketTimeSeriesConfig)obj;
            return Objects.equals((Object)this.timeUnit, (Object)btsc.timeUnit) && Objects.equals(this.timeSeriesSize, btsc.timeSeriesSize) && Objects.equals(this.bucketSize, btsc.bucketSize) && Objects.equals(this.bucketContent, btsc.bucketContent) && Objects.equals(this.fillNumberWithZero, btsc.fillNumberWithZero);
        }
        return false;
    }

    public String toString() {
        return String.format("%s-timeSeries[%d]'[%d]'(%s)", this.getTimeUnit().name().toLowerCase(), this.getTimeSeriesSize(), this.getBucketSize(), this.getBucketContent().getSimpleName());
    }

    static {
        SUPPORTED_TIME_UNITS.add(TimeUnit.SECONDS);
        SUPPORTED_TIME_UNITS.add(TimeUnit.MINUTES);
        SUPPORTED_TIME_UNITS.add(TimeUnit.HOURS);
    }
}

