/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeseries;

import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.timeseries.BucketTimeSeries;
import com.brein.time.timeseries.BucketTimeSeriesConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

public class ContainerBucketTimeSeries<E extends Serializable & Collection<T>, T>
extends BucketTimeSeries<E> {
    private static final long serialVersionUID = 1L;
    private final transient Supplier<E> supplier;

    public ContainerBucketTimeSeries(Supplier<E> supplier, BucketTimeSeriesConfig<E> config) {
        super(config);
        this.supplier = supplier;
    }

    public ContainerBucketTimeSeries(Supplier<E> supplier, BucketTimeSeriesConfig<E> config, E[] timeSeries, long now) {
        super(config, timeSeries, now);
        this.supplier = supplier;
    }

    public long[] createByContent(ContainerBucketTimeSeries<E, T> timeSeries, BiFunction<E, E, Long> create) {
        ContainerBucketTimeSeries syncedTs = this.sync(timeSeries, ts -> new ContainerBucketTimeSeries(ts.getSupplier(), ts.getConfig(), ts.timeSeries, ts.getNow()));
        long[] result = new long[this.config.getTimeSeriesSize()];
        for (int i = 0; i < this.config.getTimeSeriesSize(); ++i) {
            Object syncedColl;
            int idx = this.idx(this.currentNowIdx + i);
            Object coll = this.get(idx);
            Long val = create.apply(coll, syncedColl = syncedTs.get(syncedTs.idx(syncedTs.currentNowIdx + i)));
            result[i] = val == null ? -1L : val;
        }
        return result;
    }

    public void combineByContent(ContainerBucketTimeSeries<E, T> timeSeries, BiConsumer<E, E> combine) throws IllegalConfiguration {
        this.combineByContent(timeSeries, (E coll1, E coll2) -> {
            Serializable in2;
            Serializable in1;
            if (coll1 == null && coll2 == null) {
                in1 = (Serializable)this.getSupplier().get();
                in2 = (Serializable)this.getSupplier().get();
            } else if (coll1 == null) {
                in1 = (Serializable)this.getSupplier().get();
                in2 = coll2;
            } else if (coll2 == null) {
                in1 = coll1;
                in2 = (Serializable)this.getSupplier().get();
            } else {
                in1 = coll1;
                in2 = coll2;
            }
            combine.accept(in1, in2);
            return in1;
        });
    }

    public void combineByContent(ContainerBucketTimeSeries<E, T> timeSeries, BiFunction<E, E, E> combine) throws IllegalConfiguration {
        ContainerBucketTimeSeries syncedTs = this.sync(timeSeries, ts -> new ContainerBucketTimeSeries(ts.getSupplier(), ts.getConfig(), ts.timeSeries, ts.getNow()));
        for (int i = 0; i < this.config.getTimeSeriesSize(); ++i) {
            Object syncedColl;
            Serializable result;
            int idx = this.idx(this.currentNowIdx + i);
            Object coll = this.get(idx);
            if (coll == (result = (Serializable)combine.apply(coll, syncedColl = syncedTs.get(syncedTs.idx(syncedTs.currentNowIdx + i))))) continue;
            this.set(idx, result);
        }
    }

    public void add(long unixTimeStamp, T value) {
        int idx = this.handleDataUnixTimeStamp(unixTimeStamp);
        this.add(idx, value);
    }

    public void add(int idx, T value) {
        if (idx == -1) {
            return;
        }
        this.validateIdx(idx);
        ((Collection)this.getOrCreate(idx)).add(value);
    }

    public int size(int idx) {
        Collection coll = (Collection)this.get(idx);
        return coll == null ? 0 : coll.size();
    }

    public Supplier<E> getSupplier() {
        return this.supplier;
    }

    public Class<E> getCollectionType() {
        return ((Serializable)this.supplier.get()).getClass();
    }

    public Class<T> getCollectionContent() {
        Serializable res = StreamSupport.stream(this.spliterator(), false).filter(coll -> coll != null && ((Collection)((Object)coll)).stream().filter(val -> val != null).findFirst().orElse(null) != null).findFirst().orElse(null);
        return res == null ? null : ((Collection)((Object)res)).stream().findFirst().orElse(null).getClass();
    }

    protected E getOrCreate(int idx) {
        Object coll = this.get(idx);
        if (coll == null) {
            Serializable newColl;
            this.timeSeries[idx] = newColl = (Serializable)this.supplier.get();
            return (E)newColl;
        }
        return (E)coll;
    }
}

