/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeseries.gson;

import com.brein.time.timeseries.BucketTimeSeriesConfig;
import com.brein.time.timeseries.ContainerBucketTimeSeries;
import com.brein.time.timeseries.gson.TypeConverterHelper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;

public class ContainerBucketTimeSeriesTypeConverter
implements JsonSerializer<ContainerBucketTimeSeries>,
JsonDeserializer<ContainerBucketTimeSeries> {
    public Class<ContainerBucketTimeSeries> getType() {
        return ContainerBucketTimeSeries.class;
    }

    public JsonElement serialize(ContainerBucketTimeSeries o, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = TypeConverterHelper.serialize(o, context);
        jsonObject.add("supplier", TypeConverterHelper.serializeClass(o.getCollectionType(), context));
        jsonObject.add("collectionContent", TypeConverterHelper.serializeClass(o.getCollectionContent(), context));
        return jsonObject;
    }

    public ContainerBucketTimeSeries deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Class supplierClass = TypeConverterHelper.resolveClass("supplier", jsonObject, context);
        Supplier<Collection> supplier = () -> {
            if (supplierClass == null) {
                throw new NullPointerException();
            }
            try {
                return (Collection)supplierClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid supplier", e);
            }
        };
        Class collectionContent = TypeConverterHelper.resolveClass("collectionContent", jsonObject, context);
        Class<?> collectionContentArray = TypeConverterHelper.arrayClass(collectionContent);
        Object[] values = TypeConverterHelper.deserialize(jsonElement, context, (bucketContent, el) -> (Serializable[])context.deserialize(el, TypeConverterHelper.arrayClass(collectionContentArray)));
        Serializable[] result = this.fromJson((Object[][])values[1], supplier);
        ContainerBucketTimeSeries res = new ContainerBucketTimeSeries(supplier::get, (BucketTimeSeriesConfig)values[0], result, ((Long)values[2]).longValue());
        return res;
    }

    protected Serializable[] fromJson(Object[][] contents, Supplier<Collection> supplier) {
        int contentsLength = contents.length;
        Serializable[] result = (Serializable[])Array.newInstance(Serializable.class, contentsLength);
        for (int i = 0; i < contentsLength; ++i) {
            Collection coll;
            if (contents[i] == null) {
                coll = null;
            } else {
                coll = supplier.get();
                Collections.addAll(coll, contents[i]);
            }
            result[i] = (Serializable)Serializable.class.cast(coll);
        }
        return result;
    }
}

