/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.utils;

import com.brein.time.utils.TimeUtils;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public enum TimeModifier {
    START_OF_MINUTE,
    START_OF_HOUR,
    START_OF_DAY,
    END_OF_DAY,
    START_OF_MONTH,
    NONE;


    public static long moveDays(long timestamp, boolean normalize, long days) {
        ZonedDateTime dateTime = TimeUtils.toZone(timestamp, TimeUtils.UTC);
        ZonedDateTime normDateTime = normalize ? START_OF_DAY.applyModifier(dateTime) : dateTime;
        return normDateTime.plusDays(days).toEpochSecond();
    }

    public static long moveMonths(long timestamp, boolean normalize, long months) {
        ZonedDateTime dateTime = TimeUtils.toZone(timestamp, TimeUtils.UTC);
        ZonedDateTime normDateTime = normalize ? START_OF_MONTH.applyModifier(dateTime) : dateTime;
        return normDateTime.plusMonths(months).toEpochSecond();
    }

    public ZonedDateTime applyModifier(ZonedDateTime dateTime) {
        if (START_OF_MINUTE.equals((Object)this)) {
            return dateTime.truncatedTo(ChronoUnit.MINUTES);
        }
        if (START_OF_HOUR.equals((Object)this)) {
            return dateTime.truncatedTo(ChronoUnit.HOURS);
        }
        if (START_OF_DAY.equals((Object)this)) {
            return dateTime.truncatedTo(ChronoUnit.DAYS);
        }
        if (END_OF_DAY.equals((Object)this)) {
            return dateTime.truncatedTo(ChronoUnit.DAYS).plusDays(1L).minusSeconds(1L);
        }
        if (START_OF_MONTH.equals((Object)this)) {
            return dateTime.withDayOfMonth(1).with(LocalTime.of(0, 0));
        }
        if (NONE.equals((Object)this)) {
            return dateTime;
        }
        throw new IllegalArgumentException("Unexpected TimeModifier: " + (Object)((Object)this));
    }

    public long applyModifier(long timestamp) {
        return this.applyModifier(TimeUtils.toZone(timestamp, TimeUtils.UTC)).toEpochSecond();
    }
}

