/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.utils;

import com.brein.time.utils.TimeModifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class TimeUtils {
    public static final ZoneId UTC = ZoneId.of("UTC");
    protected static final Map<String, ZoneId> ZONES = new HashMap<String, ZoneId>();
    private static final Logger LOGGER = Logger.getLogger(TimeUtils.class);

    private TimeUtils() {
    }

    public static String format(long unixTimeStamp) {
        return TimeUtils.formatUnixTimeStamp("yyyy-MM-dd HH:mm:ss z", unixTimeStamp);
    }

    public static String formatUnixTimeStamp(long unixTimeStamp) {
        return TimeUtils.formatUnixTimeStamp("yyyy/MM/dd HH:mm:ss", unixTimeStamp);
    }

    public static String formatUnixTimeStamp(String format, long unixTimeStamp) {
        return TimeUtils.format(format, unixTimeStamp, UTC);
    }

    public static String format(String format, long unixTimeStamp, String zone) {
        return TimeUtils.format(format, unixTimeStamp, TimeUtils.zoneId(zone));
    }

    public static String format(String format, long unixTimeStamp, ZoneId zone) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return Instant.ofEpochSecond(unixTimeStamp).atZone(zone).format(formatter);
    }

    public static long now() {
        return Instant.now().getEpochSecond();
    }

    public static int secondsToFullMinute(long now) {
        return TimeUtils.secondsToFullMinute(now, 0);
    }

    public static int secondsToFullMinute(long now, int offset) {
        int value = Long.valueOf(60L - (now + (long)offset) % 60L).intValue();
        return value == 60 ? 0 : value;
    }

    public static Calendar createFirstOfMonthCal(long unixTimestamp) {
        Calendar nowCalendar = TimeUtils.createCal(unixTimestamp);
        Calendar firstOfMonthCal = TimeUtils.createCal();
        firstOfMonthCal.set(nowCalendar.get(1), nowCalendar.get(2), 1, 0, 0, 0);
        return firstOfMonthCal;
    }

    public static Calendar createCal() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public static Calendar createCal(long unixTimeStamp) {
        Calendar cal = TimeUtils.createCal();
        cal.setTimeInMillis(unixTimeStamp * 1000L);
        return cal;
    }

    @Deprecated
    public static long firstOfNextMonthTime(long unixTimestamp) {
        Calendar cal = TimeUtils.createFirstOfMonthCal(unixTimestamp);
        cal.add(2, 1);
        return cal.getTimeInMillis() / 1000L;
    }

    public static long firstOfLastMonthTime(long unixTimestamp) {
        Calendar cal = TimeUtils.createFirstOfMonthCal(unixTimestamp);
        cal.add(2, -1);
        return cal.getTimeInMillis() / 1000L;
    }

    public static long firstOfCurrentMonthTime(long unixTimestamp) {
        Calendar cal = TimeUtils.createFirstOfMonthCal(unixTimestamp);
        return cal.getTimeInMillis() / 1000L;
    }

    public static boolean isSameMonth(long unixTimestamp1, long unixTimestamp2) {
        Calendar cal1 = TimeUtils.createCal(unixTimestamp1);
        Calendar cal2 = TimeUtils.createCal(unixTimestamp2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean validateDate(String day, String month, String year) {
        if (day == null || month == null || year == null) {
            return false;
        }
        String format = "dd-MM-uuuu";
        String date = String.format("%02d-%02d-%s", Integer.parseInt(day), Integer.parseInt(month), year);
        try {
            LocalDate.parse(date, DateTimeFormatter.ofPattern("dd-MM-uuuu").withResolverStyle(ResolverStyle.STRICT));
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public static ZonedDateTime toZone(long utc, String zoneId) {
        return TimeUtils.toZone(utc, TimeUtils.zoneId(zoneId));
    }

    public static ZonedDateTime toZone(long utc, ZoneId toZone) {
        Instant instant = Instant.ofEpochSecond(utc);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, UTC);
        return TimeUtils.toZone(zdt, toZone);
    }

    public static ZonedDateTime toZone(ZonedDateTime utc, String zoneId) {
        return TimeUtils.toZone(utc, TimeUtils.zoneId(zoneId));
    }

    public static ZonedDateTime toZone(ZonedDateTime utc, ZoneId toZone) {
        if (!UTC.equals(utc.getZone())) {
            throw new IllegalArgumentException("Expecting UTC time.");
        }
        return utc.withZoneSameInstant(toZone);
    }

    public static ZoneId zoneId(String tzId) {
        return TimeUtils.zoneId(tzId, true);
    }

    public static ZoneId zoneId(String tzId, boolean caseSensitive) {
        if (tzId == null) {
            return null;
        }
        if (caseSensitive) {
            try {
                return ZoneId.of(tzId);
            }
            catch (Exception e) {
                return null;
            }
        }
        return ZONES.get(tzId.toLowerCase());
    }

    @Deprecated
    public static long toMidnight(long time) {
        return TimeModifier.START_OF_DAY.applyModifier(time);
    }

    public static long dateStringToUnixTimestamp(String dateString, String format) {
        return TimeUtils.dateStringToUnixTimestamp(dateString, format, UTC);
    }

    public static long dateStringToUnixTimestamp(String dateString, String format, String timezone) {
        return TimeUtils.dateStringToUnixTimestamp(dateString, DateTimeFormatter.ofPattern(format), timezone);
    }

    public static long dateStringToUnixTimestamp(String dateString, String format, ZoneId zone) {
        return TimeUtils.dateStringToUnixTimestamp(dateString, DateTimeFormatter.ofPattern(format), zone);
    }

    public static long dateStringToUnixTimestamp(String dateString, DateTimeFormatter formatter, String timezone) {
        return TimeUtils.dateStringToUnixTimestamp(dateString, formatter, TimeUtils.getZone(timezone));
    }

    public static long dateStringToUnixTimestamp(String dateString, DateTimeFormatter formatter, ZoneId zone) {
        if (dateString == null || dateString.isEmpty()) {
            return -1L;
        }
        try {
            return LocalDateTime.parse(dateString, formatter).atZone(zone).toEpochSecond();
        }
        catch (DateTimeParseException e) {
            LOGGER.error((Object)("Unable to parse date '" + dateString + "'"), (Throwable)e);
            return -1L;
        }
    }

    public static long dateStringModifyToUnixTimestamp(String dateString, String format, String timezone, TimeModifier modifier) {
        return TimeUtils.dateStringModifyToUnixTimestamp(dateString, DateTimeFormatter.ofPattern(format), timezone, modifier);
    }

    public static long dateStringModifyToUnixTimestamp(String dateString, DateTimeFormatter formatter, String timezone, TimeModifier modifier) {
        if (dateString == null || dateString.isEmpty()) {
            return -1L;
        }
        try {
            ZonedDateTime dateTime = LocalDateTime.parse(dateString, formatter).atZone(TimeUtils.getZone(timezone));
            if (modifier != null) {
                dateTime = modifier.applyModifier(dateTime);
            }
            return dateTime.toEpochSecond();
        }
        catch (DateTimeParseException e) {
            LOGGER.error((Object)("Unable to parse date '" + dateString + "'"));
            return -1L;
        }
    }

    public static String convertDateFormat(String dateString, String fromFormat, String toFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(fromFormat);
        try {
            Date date = dateFormat.parse(dateString);
            dateFormat.applyPattern(toFormat);
            return dateFormat.format(date);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Unable to parse date format: " + fromFormat));
            return null;
        }
    }

    public static String secondsToPrettyString(long seconds) {
        String type;
        double converted;
        if (seconds < 0L) {
            return "-" + TimeUtils.secondsToPrettyString(-seconds);
        }
        if (seconds >= 63072000L) {
            converted = (double)(seconds / 365L / 24L / 60L) / 60.0;
            type = "years";
        } else if (seconds >= 1209600L) {
            converted = (double)(seconds / 7L / 24L / 60L) / 60.0;
            type = "weeks";
        } else if (seconds >= 172800L) {
            converted = (double)(seconds / 24L / 60L) / 60.0;
            type = "days";
        } else if (seconds >= 7200L) {
            converted = (double)(seconds / 60L) / 60.0;
            type = "hours";
        } else if (seconds >= 120L) {
            converted = (double)seconds / 60.0;
            type = "minutes";
        } else if (seconds == 1L) {
            converted = 1.0;
            type = "second";
        } else {
            converted = seconds;
            type = "seconds";
        }
        return Math.round(converted) + " " + type;
    }

    public static List<Long> createTimestampList(long startUnixTimestamp, long endUnixTimestamp) {
        if (startUnixTimestamp > endUnixTimestamp) {
            return Collections.emptyList();
        }
        long normStart = TimeModifier.START_OF_DAY.applyModifier(startUnixTimestamp);
        long normEnd = TimeModifier.moveDays(endUnixTimestamp, true, 1L);
        ArrayList<Long> times = new ArrayList<Long>();
        for (long time = normStart; time < normEnd; time += 86400L) {
            times.add(time);
        }
        return times;
    }

    protected static ZoneId getZone(String timezone) {
        return timezone == null ? UTC : ZoneId.of(timezone);
    }

    static {
        ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).forEach(zoneId -> ZONES.put(zoneId.getId().toLowerCase(), (ZoneId)zoneId));
    }
}

