/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.utils.monitor;

import com.btmatthews.utils.monitor.Logger;
import com.btmatthews.utils.monitor.ServerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class ServerFactoryLocator {
    private static ServerFactoryLocator instance;
    private final Map<String, ServerFactory> serverFactoryMapping = new HashMap<String, ServerFactory>();

    public static ServerFactoryLocator getInstance(Logger logger) {
        return ServerFactoryLocator.getInstance(logger, ServerFactoryLocator.class.getClassLoader());
    }

    public static ServerFactoryLocator getInstance(Logger logger, ClassLoader classLoader) {
        if (instance == null) {
            instance = new ServerFactoryLocator(logger, classLoader);
        }
        return instance;
    }

    public ServerFactoryLocator(Logger logger, ClassLoader classLoader) {
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/service/com.btmatthews.utils.monitor.ServerFactory");
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                this.loadServerFactories(resourceUrl, logger);
            }
        }
        catch (IOException e) {
            logger.logError("Error loading META-INF/service/com.btmatthews.utils.monitor.ServerFactory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadServerFactories(URL url, Logger logger) throws IOException {
        InputStream resourceStream = url.openStream();
        try {
            this.loadServerFactories(resourceStream, logger);
        }
        finally {
            resourceStream.close();
        }
    }

    private void loadServerFactories(InputStream inputStream, Logger logger) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String serverFactoryClassName = reader.readLine();
        while (serverFactoryClassName != null) {
            if (serverFactoryClassName.length() > 0) {
                String message;
                try {
                    Class<?> serverFactoryClass = Class.forName(serverFactoryClassName);
                    ServerFactory serverFactory = (ServerFactory)serverFactoryClass.newInstance();
                    this.serverFactoryMapping.put(serverFactory.getServerName(), serverFactory);
                }
                catch (ClassNotFoundException e) {
                    message = MessageFormat.format("Class {0} not found", serverFactoryClassName);
                    logger.logError(message, e);
                }
                catch (IllegalAccessException e) {
                    message = MessageFormat.format("Cannot access class {0} or its constructor", serverFactoryClassName);
                    logger.logError(message, e);
                }
                catch (InstantiationException e) {
                    message = MessageFormat.format("Class {0} cannot be instantiated", serverFactoryClassName);
                    logger.logError(message, e);
                }
            }
            serverFactoryClassName = reader.readLine();
        }
    }

    public ServerFactory getFactory(String serverName) {
        return this.serverFactoryMapping.get(serverName);
    }
}

