/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlUtilities {
    private static final Log LOG = LogFactory.getLog(UrlUtilities.class);
    private static String _referer = null;
    private static String _userAgent = null;
    private static final Pattern resPattern = Pattern.compile("res:\\/\\/(.+)", 2);
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE_VALUE_DELIMITER = ";";
    public static final String PATH = "path";
    public static final String EXPIRES = "expires";
    public static final SafeSimpleDateFormat DATE_FORMAT = new SafeSimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    public static final String SET_COOKIE_SEPARATOR = "; ";
    public static final String COOKIE = "Cookie";
    public static final char NAME_VALUE_SEPARATOR = '=';
    public static final char DOT = '.';

    private UrlUtilities() {
    }

    public static void setReferer(String referer) {
        _referer = referer;
    }

    public static void setUserAgent(String userAgent) {
        _userAgent = userAgent;
    }

    public static String getUserAgent() {
        return _userAgent;
    }

    private static void setProperty(String name, String value) {
        System.setProperty(name, value);
    }

    public static URLConnection getConnection(String url, boolean input, boolean output, boolean cache) throws IOException {
        return UrlUtilities.getConnection(new URL(url), input, output, cache);
    }

    public static URLConnection getConnection(URL url, boolean input, boolean output, boolean cache) throws IOException {
        URLConnection c = url.openConnection();
        c.setRequestProperty("Accept-Encoding", "gzip, deflate");
        if (StringUtilities.hasContent(_referer)) {
            c.setRequestProperty("Referer", _referer);
        }
        if (StringUtilities.hasContent(_userAgent)) {
            c.setRequestProperty("User-Agent", _userAgent);
        }
        c.setAllowUserInteraction(false);
        c.setDoOutput(output);
        c.setDoInput(input);
        c.setUseCaches(cache);
        UrlUtilities.setTimeouts(c, 220000, 45000);
        return c;
    }

    public static void setTimeouts(URLConnection c, int read, int connect) {
        c.setReadTimeout(read);
        c.setConnectTimeout(connect);
    }

    /*
     * Exception decompiling
     */
    public static void readErrorResponse(URLConnection c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void disconnect(HttpURLConnection c) {
        if (c != null) {
            try {
                c.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getCookies(URLConnection conn, Map store) {
        String headerName;
        Map domainStore;
        String domain = UrlUtilities.getCookieDomainFromHost(conn.getURL().getHost());
        if (store.containsKey(domain)) {
            domainStore = (Map)store.get(domain);
        } else {
            domainStore = new ConcurrentHashMap();
            store.put(domain, domainStore);
        }
        if (domainStore.containsKey("JSESSIONID")) {
            return;
        }
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            if (headerName.equalsIgnoreCase(SET_COOKIE)) {
                String token;
                ConcurrentHashMap<String, String> cookie = new ConcurrentHashMap<String, String>();
                StringTokenizer st = new StringTokenizer(conn.getHeaderField(i), COOKIE_VALUE_DELIMITER);
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    String key = token.substring(0, token.indexOf(61)).trim();
                    String value = token.substring(token.indexOf(61) + 1);
                    domainStore.put(key, cookie);
                    cookie.put(key, value);
                }
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    int pos = token.indexOf(61);
                    if (pos == -1) continue;
                    String key = token.substring(0, pos).toLowerCase().trim();
                    String value = token.substring(token.indexOf(61) + 1);
                    cookie.put(key, value);
                }
            }
            ++i;
        }
    }

    public static void setCookies(URLConnection conn, Map store) throws IOException {
        URL url = conn.getURL();
        String domain = UrlUtilities.getCookieDomainFromHost(url.getHost());
        String path = url.getPath();
        Map domainStore = (Map)store.get(domain);
        if (domainStore == null) {
            return;
        }
        StringBuilder cookieStringBuffer = new StringBuilder();
        Iterator cookieNames = domainStore.keySet().iterator();
        while (cookieNames.hasNext()) {
            String cookieName = (String)cookieNames.next();
            Map cookie = (Map)domainStore.get(cookieName);
            if (!UrlUtilities.comparePaths((String)cookie.get(PATH), path) || !UrlUtilities.isNotExpired((String)cookie.get(EXPIRES))) continue;
            cookieStringBuffer.append(cookieName);
            cookieStringBuffer.append('=');
            cookieStringBuffer.append((String)cookie.get(cookieName));
            if (!cookieNames.hasNext()) continue;
            cookieStringBuffer.append(SET_COOKIE_SEPARATOR);
        }
        try {
            conn.setRequestProperty(COOKIE, cookieStringBuffer.toString());
        }
        catch (IllegalStateException e) {
            throw new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected. Only call setCookies(java.net.URLConnection) AFTER calling java.net.URLConnection.connect().");
        }
    }

    public static String getCookieDomainFromHost(String host) {
        while (host.indexOf(46) != host.lastIndexOf(46)) {
            host = host.substring(host.indexOf(46) + 1);
        }
        return host;
    }

    private static boolean isNotExpired(String cookieExpires) {
        if (cookieExpires == null) {
            return true;
        }
        try {
            return new Date().compareTo(DATE_FORMAT.parse(cookieExpires)) <= 0;
        }
        catch (ParseException e) {
            LOG.info((Object)("Parse error on cookie expires value: " + cookieExpires), (Throwable)e);
            return false;
        }
    }

    private static boolean comparePaths(String cookiePath, String targetPath) {
        if (cookiePath == null) {
            return true;
        }
        if ("/".equals(cookiePath)) {
            return true;
        }
        return targetPath.regionMatches(0, cookiePath, 0, cookiePath.length());
    }

    public static String getContentFromUrlAsString(String url) {
        try {
            return new String(UrlUtilities.getContentFromUrl(url), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported by your JVM.  Get a newer JVM.", e);
        }
    }

    public static byte[] getContentFromUrl(String url) {
        return UrlUtilities.getContentFromUrl(url, null, 0, null, null, true);
    }

    public static String getContentFromUrlAsString(String url, String proxyServer, int port, Map inCookies, Map outCookies, boolean ignoreSec) {
        try {
            return new String(UrlUtilities.getContentFromUrl(url, proxyServer, port, inCookies, outCookies, ignoreSec), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported by your JVM.  Get a newer JVM.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContentFromUrl(String url, String proxyServer, int port, Map inCookies, Map outCookies, boolean ignoreSec) {
        HttpURLConnection c = null;
        try {
            Matcher m = resPattern.matcher(url);
            URL u = m.matches() ? UrlUtilities.class.getClassLoader().getResource(url.substring(m.end())) : new URL(url);
            c = (HttpURLConnection)UrlUtilities.getConnection(u, proxyServer, port, inCookies, true, false, false, ignoreSec);
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            InputStream stream = IOUtilities.getInputStream(c);
            IOUtilities.transfer(stream, (OutputStream)out);
            stream.close();
            if (outCookies != null) {
                UrlUtilities.getCookies(c, outCookies);
            }
            byte[] byArray = out.toByteArray();
            UrlUtilities.disconnect(c);
            return byArray;
        }
        catch (Exception e) {
            UrlUtilities.readErrorResponse(c);
            LOG.warn((Object)("Exception occurred fetching content from url: " + url), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            UrlUtilities.disconnect(c);
        }
    }

    public static URLConnection getConnection(URL url, String proxyServer, int port, Map inCookies, boolean input, boolean output, boolean cache, boolean ignoreSec) throws IOException {
        URLConnection c;
        if (proxyServer != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyServer, port));
            c = url.openConnection(proxy);
        } else {
            c = url.openConnection();
        }
        c.setRequestProperty("Accept-Encoding", "gzip, deflate");
        c.setAllowUserInteraction(false);
        c.setDoOutput(output);
        c.setDoInput(input);
        c.setUseCaches(cache);
        if (c instanceof HttpURLConnection) {
            HttpURLConnection.setFollowRedirects(true);
        }
        c.setReadTimeout(220000);
        c.setConnectTimeout(45000);
        if (c instanceof HttpsURLConnection && ignoreSec) {
            HttpsURLConnection sc = (HttpsURLConnection)c;
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
                sc.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not access '" + url.toString() + "'"), (Throwable)e);
            }
        }
        if (inCookies != null) {
            UrlUtilities.setCookies(c, inCookies);
        }
        return c;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Unable to fetch 'hostname'", (Throwable)e);
            return "localhost";
        }
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

