/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.SealableList;
import com.cedarsoftware.util.SealableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class SealableMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final transient Supplier<Boolean> sealedSupplier;

    public SealableMap(Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.map = new ConcurrentHashMap();
    }

    public SealableMap(Map<K, V> map, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.map = map;
    }

    private void throwIfSealed() {
        if (this.sealedSupplier.get().booleanValue()) {
            throw new UnsupportedOperationException("This map has been sealed and is now immutable");
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<K> keySet() {
        return new SealableSet<K>(this.map.keySet(), this.sealedSupplier);
    }

    @Override
    public Collection<V> values() {
        return new SealableList<V>(new ArrayList<V>(this.map.values()), this.sealedSupplier);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SealableSet<Map.Entry<K, V>>(this.map.entrySet(), this.sealedSupplier);
    }

    @Override
    public V put(K key, V value) {
        this.throwIfSealed();
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.throwIfSealed();
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.throwIfSealed();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.throwIfSealed();
        this.map.clear();
    }
}

