/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockingLRUCacheStrategy<K, V>
implements Map<K, V> {
    private static final Object NULL_ITEM = new Object();
    private final int capacity;
    private final ConcurrentHashMap<Object, Node<K, V>> cache;
    private final Node<K, V> head;
    private final Node<K, V> tail;
    private final Lock lock = new ReentrantLock();

    public LockingLRUCacheStrategy(int capacity) {
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap(capacity);
        this.head = new Node<Object, Object>(null, null);
        this.tail = new Node<Object, Object>(null, null);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    private void moveToHead(Node<K, V> node) {
        if (node.prev == null || node.next == null) {
            return;
        }
        this.removeNode(node);
        this.addToHead(node);
    }

    private void addToHead(Node<K, V> node) {
        node.next = this.head.next;
        node.next.prev = node;
        this.head.next = node;
        node.prev = this.head;
    }

    private void removeNode(Node<K, V> node) {
        if (node.prev != null && node.next != null) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
    }

    private Node<K, V> removeTail() {
        Node node = this.tail.prev;
        if (node != this.head) {
            this.removeNode(node);
            node.prev = null;
            node.next = null;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object cacheKey = this.toCacheItem(key);
        Node<K, V> node = this.cache.get(cacheKey);
        if (node == null) {
            return null;
        }
        if (this.lock.tryLock()) {
            try {
                this.moveToHead(node);
            }
            finally {
                this.lock.unlock();
            }
        }
        return (V)this.fromCacheItem(node.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object cacheKey = this.toCacheItem(key);
        Object cacheValue = this.toCacheItem(value);
        this.lock.lock();
        try {
            Node<K, V> node = this.cache.get(cacheKey);
            if (node != null) {
                node.value = cacheValue;
                this.moveToHead(node);
                Object t = this.fromCacheItem(node.value);
                return (V)t;
            }
            Node<K, Object> newNode = new Node<K, Object>(key, cacheValue);
            this.cache.put(cacheKey, newNode);
            this.addToHead(newNode);
            if (this.cache.size() > this.capacity) {
                Node<K, V> tail = this.removeTail();
                this.cache.remove(this.toCacheItem(tail.key));
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.lock();
        try {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object cacheKey = this.toCacheItem(key);
        this.lock.lock();
        try {
            Node<K, V> node = this.cache.remove(cacheKey);
            if (node != null) {
                this.removeNode(node);
                Object t = this.fromCacheItem(node.value);
                return (V)t;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.head.next = this.tail;
            this.tail.prev = this.head;
            this.cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(this.toCacheItem(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object cacheValue = this.toCacheItem(value);
        this.lock.lock();
        try {
            Node node = this.head.next;
            while (node != this.tail) {
                if (node.value.equals(cacheValue)) {
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.lock();
        try {
            LinkedHashMap map = new LinkedHashMap();
            Node node = this.head.next;
            while (node != this.tail) {
                map.put(node.key, this.fromCacheItem(node.value));
                node = node.next;
            }
            Set set = map.entrySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.lock.lock();
        try {
            LinkedHashMap map = new LinkedHashMap();
            Node node = this.head.next;
            while (node != this.tail) {
                map.put(node.key, this.fromCacheItem(node.value));
                node = node.next;
            }
            Set set = map.keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        this.lock.lock();
        try {
            LinkedHashMap map = new LinkedHashMap();
            Node node = this.head.next;
            while (node != this.tail) {
                map.put(node.key, this.fromCacheItem(node.value));
                node = node.next;
            }
            Collection collection = map.values();
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    public String toString() {
        this.lock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            Node node = this.head.next;
            while (node != this.tail) {
                sb.append(this.fromCacheItem(node.key)).append("=").append(this.fromCacheItem(node.value)).append(", ");
                node = node.next;
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("}");
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.lock.lock();
        try {
            int hashCode = 1;
            Node node = this.head.next;
            while (node != this.tail) {
                Object key = this.fromCacheItem(node.key);
                Object value = this.fromCacheItem(node.value);
                hashCode = 31 * hashCode + (key == null ? 0 : key.hashCode());
                hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
                node = node.next;
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Object toCacheItem(Object item) {
        return item == null ? NULL_ITEM : item;
    }

    private <T> T fromCacheItem(Object cacheItem) {
        return (T)(cacheItem == NULL_ITEM ? null : cacheItem);
    }

    private static class Node<K, V> {
        K key;
        V value;
        Node<K, V> prev;
        Node<K, V> next;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

