/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.integration.jul;

import com.cloudbees.syslog.integration.jul.util.LogManagerHelper;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHandler
extends Handler {
    private Level logLevel = Level.ALL;
    private Filter filter;
    private Formatter formatter;

    public AbstractHandler() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.logLevel = LogManagerHelper.getLevelProperty(manager, cname + ".level", Level.INFO);
        this.filter = LogManagerHelper.getFilterProperty(manager, cname + ".filter", null);
        this.formatter = LogManagerHelper.getFormatterProperty(manager, cname + ".formatter", this.getDefaultFormatter());
    }

    public AbstractHandler(@Nonnull Level level, @Nullable Filter filter) {
        this.logLevel = level;
        this.filter = filter;
        this.formatter = this.getDefaultFormatter();
    }

    @Nonnull
    protected Formatter getDefaultFormatter() {
        return new SimpleFormatter();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (record == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    @Override
    public Level getLevel() {
        return this.logLevel;
    }

    @Override
    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void setFormatter(Formatter formatter) throws SecurityException {
        this.formatter = formatter;
    }
}

