/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.CollectionSnapshot;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public abstract class BaseElementsCollection<T extends SelenideElement, SELF extends BaseElementsCollection<T, SELF>>
implements Iterable<T> {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final Class<T> clazz;
    private final CollectionSource collection;

    @SafeVarargs
    protected BaseElementsCollection(CollectionSource collection, T ... clazz) {
        this.clazz = Util.classOf(clazz);
        this.collection = collection;
    }

    @SafeVarargs
    protected BaseElementsCollection(Driver driver, Collection<? extends WebElement> elements, T ... clazz) {
        this(new WebElementsCollectionWrapper(driver, elements), (SelenideElement[])clazz);
    }

    @SafeVarargs
    protected BaseElementsCollection(Driver driver, String cssSelector, T ... clazz) {
        this(driver, By.cssSelector((String)cssSelector), (SelenideElement[])clazz);
    }

    @SafeVarargs
    protected BaseElementsCollection(Driver driver, By seleniumSelector, T ... clazz) {
        this(new BySelectorCollection(driver, seleniumSelector), (SelenideElement[])clazz);
    }

    @CanIgnoreReturnValue
    public SELF should(WebElementsCondition ... conditions) {
        return this.should("", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @CanIgnoreReturnValue
    public SELF should(WebElementsCondition condition, Duration timeout) {
        return this.should("", timeout, this.toArray(condition));
    }

    @CanIgnoreReturnValue
    public SELF shouldBe(WebElementsCondition ... conditions) {
        return this.should("be", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @CanIgnoreReturnValue
    public SELF shouldBe(WebElementsCondition condition, Duration timeout) {
        return this.should("be", timeout, this.toArray(condition));
    }

    @CanIgnoreReturnValue
    public SELF shouldHave(WebElementsCondition ... conditions) {
        return this.should("have", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @CanIgnoreReturnValue
    public SELF shouldHave(WebElementsCondition condition, Duration timeout) {
        return this.should("have", timeout, this.toArray(condition));
    }

    private WebElementsCondition[] toArray(WebElementsCondition condition) {
        return new WebElementsCondition[]{condition};
    }

    protected SELF should(String prefix, Duration timeout, WebElementsCondition ... conditions) {
        ErrorsCollector.validateAssertionMode(this.driver().config());
        SelenideLog log = SelenideLogger.beginStep(this.collection.shortDescription(), "should " + prefix, conditions);
        try {
            for (WebElementsCondition condition : conditions) {
                this.waitUntil(condition, timeout);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this.self();
        }
        catch (AssertionError error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), (Error)((Object)error), timeout.toMillis());
            SelenideLogger.commitStep(log, wrappedError);
            switch (this.driver().config().assertionMode()) {
                case SOFT: {
                    break;
                }
                default: {
                    throw wrappedError;
                }
            }
            return this.self();
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    private SELF self() {
        return (SELF)this;
    }

    protected void waitUntil(WebElementsCondition condition, Duration timeout) {
        Object lastError = null;
        CheckResult lastCheckResult = new CheckResult(CheckResult.Verdict.REJECT, null);
        Stopwatch stopwatch = new Stopwatch(timeout);
        do {
            try {
                lastCheckResult = condition.check(this.collection);
                if (lastCheckResult.verdict() == CheckResult.Verdict.ACCEPT) {
                    return;
                }
            }
            catch (JavascriptException | UnsupportedCommandException e) {
                throw e;
            }
            catch (UIAssertionError | IndexOutOfBoundsException | WebDriverException elementNotFound) {
                if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                    throw Cleanup.of.wrapInvalidSelectorException((Throwable)elementNotFound);
                }
                if (condition.missingElementsSatisfyCondition()) {
                    return;
                }
                lastError = elementNotFound;
            }
            this.sleep(stopwatch);
        } while (!stopwatch.isTimeoutReached());
        if (lastError instanceof IndexOutOfBoundsException) {
            throw new ElementNotFound(this.collection.getAlias(), this.collection.description(), Condition.exist, (Throwable)lastError);
        }
        if (lastError instanceof UIAssertionError) {
            UIAssertionError uiAssertionError = (UIAssertionError)((Object)lastError);
            throw uiAssertionError;
        }
        condition.fail(this.collection, lastCheckResult, (Exception)lastError, timeout.toMillis());
    }

    void sleep(Stopwatch stopwatch) {
        stopwatch.sleep(this.driver().config().pollingInterval());
    }

    public SELF filter(WebElementCondition condition) {
        return this.create(new FilteringCollection(this.collection, condition));
    }

    protected abstract SELF create(CollectionSource var1);

    public SELF filterBy(WebElementCondition condition) {
        return this.filter(condition);
    }

    public SELF exclude(WebElementCondition condition) {
        return this.create(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    public SELF excludeWith(WebElementCondition condition) {
        return this.exclude(condition);
    }

    public SelenideElement find(WebElementCondition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    public SelenideElement findBy(WebElementCondition condition) {
        return this.find(condition);
    }

    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    public List<String> texts() {
        return communicator.texts(this.driver(), this.getElements());
    }

    public List<@Nullable String> attributes(String attribute) {
        return communicator.attributes(this.driver(), this.getElements(), attribute);
    }

    public T get(int index) {
        return CollectionElement.wrap(this.clazz, this.collection, index);
    }

    public SelenideElement first() {
        return this.get(0);
    }

    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    public SELF first(int elements) {
        return this.create(new HeadOfCollection(this.collection, elements));
    }

    public SELF last(int elements) {
        return this.create(new TailOfCollection(this.collection, elements));
    }

    public int size() {
        try {
            return this.getElements().size();
        }
        catch (IndexOutOfBoundsException outOfCollection) {
            return 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public SELF snapshot() {
        return this.create(new CollectionSnapshot(this.collection));
    }

    @Override
    public Iterator<T> iterator() {
        return this.asFixedIterable().iterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public SelenideElementIterable<T> asFixedIterable() {
        return () -> new SelenideElementIterator<T>(new CollectionSnapshot(this.collection), this.clazz);
    }

    public SelenideElementIterable<T> asDynamicIterable() {
        return () -> new SelenideElementIterator<T>(this.collection, this.clazz);
    }

    @CanIgnoreReturnValue
    public SELF as(String alias) {
        this.collection.setAlias(alias);
        return this.self();
    }

    public String toString() {
        return this.collection.getAlias().getOrElse(this.collection::toString);
    }

    public String describe() {
        return this.stream().map(el -> el.describe()).toList().toString();
    }

    private Driver driver() {
        return this.collection.driver();
    }

    @FunctionalInterface
    public static interface SelenideElementIterable<T extends SelenideElement>
    extends Iterable<T> {
        default public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

