/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import org.jspecify.annotations.Nullable;

public class ClickOptions
implements HasTimeout {
    private final int offsetX;
    private final int offsetY;
    private final ClickMethod clickMethod;
    private final @Nullable Duration timeout;
    private final boolean force;

    protected ClickOptions(ClickMethod clickMethod, int offsetX, int offsetY, @Nullable Duration timeout, boolean force) {
        this.clickMethod = clickMethod;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.timeout = timeout;
        this.force = force;
    }

    public static ClickOptions usingDefaultMethod() {
        return new ClickOptions(ClickMethod.DEFAULT, 0, 0, null, false);
    }

    public static ClickOptions usingJavaScript() {
        return new ClickOptions(ClickMethod.JS, 0, 0, null, false);
    }

    public static ClickOptions withOffset(int offsetX, int offsetY) {
        return new ClickOptions(ClickMethod.DEFAULT, offsetX, offsetY, null, false);
    }

    public static ClickOptions withTimeout(Duration timeout) {
        return new ClickOptions(ClickMethod.DEFAULT, 0, 0, timeout, false);
    }

    public int offsetX() {
        return this.offsetX;
    }

    public int offsetY() {
        return this.offsetY;
    }

    public ClickMethod clickMethod() {
        return this.clickMethod;
    }

    @Override
    public @Nullable Duration timeout() {
        return this.timeout;
    }

    public boolean isForce() {
        return this.force;
    }

    public ClickOptions offsetX(int offsetX) {
        return new ClickOptions(this.clickMethod, offsetX, this.offsetY, this.timeout, this.force);
    }

    public ClickOptions offsetY(int offsetY) {
        return new ClickOptions(this.clickMethod, this.offsetX, offsetY, this.timeout, this.force);
    }

    public ClickOptions offset(int offsetX, int offsetY) {
        return new ClickOptions(this.clickMethod, offsetX, offsetY, this.timeout, this.force);
    }

    public ClickOptions timeout(Duration timeout) {
        return new ClickOptions(this.clickMethod, this.offsetX, this.offsetY, timeout, this.force);
    }

    public ClickOptions force() {
        return new ClickOptions(this.clickMethod, this.offsetX, this.offsetY, this.timeout, true);
    }

    public String toString() {
        if (this.offsetX == 0 && this.offsetY == 0 && this.timeout == null) {
            return String.format("method: %s", new Object[]{this.clickMethod});
        }
        if (this.timeout == null) {
            return String.format("method: %s, offsetX: %s, offsetY: %s", new Object[]{this.clickMethod, this.offsetX, this.offsetY});
        }
        return String.format("method: %s, offsetX: %s, offsetY: %s, timeout: %s", new Object[]{this.clickMethod, this.offsetX, this.offsetY, this.timeout});
    }
}

