/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public interface Driver {
    public Config config();

    public Browser browser();

    public boolean hasWebDriverStarted();

    public WebDriver getWebDriver();

    public SelenideProxyServer getProxy();

    public WebDriver getAndCheckWebDriver();

    public @Nullable DownloadsFolder browserDownloadsFolder();

    public void close();

    default public boolean supportsJavascript() {
        return this.hasWebDriverStarted() && JavaScript.asJsExecutor((SearchContext)this.getWebDriver()).isPresent();
    }

    @CanIgnoreReturnValue
    default public <T> @Nullable T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)JavaScript.jsExecutor((SearchContext)this.getWebDriver()).executeScript(jsCode, arguments);
    }

    @CanIgnoreReturnValue
    default public <T> @Nullable T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return (T)JavaScript.jsExecutor((SearchContext)this.getWebDriver()).executeAsyncScript(jsCode, arguments);
    }

    default public void clearCookies() {
        if (this.hasWebDriverStarted()) {
            this.getWebDriver().manage().deleteAllCookies();
        }
    }

    default public String getUserAgent() {
        return Objects.requireNonNull((String)this.executeJavaScript("return navigator.userAgent;", new Object[0]));
    }

    default public @Nullable String source() {
        return this.getWebDriver().getPageSource();
    }

    default public String url() {
        return Objects.requireNonNull(this.getWebDriver().getCurrentUrl());
    }

    default public String getCurrentFrameUrl() {
        return Objects.requireNonNull(this.executeJavaScript("return window.location.href", new Object[0])).toString();
    }

    default public SelenideTargetLocator switchTo() {
        return new SelenideTargetLocator(this);
    }

    default public Actions actions() {
        return new Actions(this.getWebDriver());
    }

    default public SessionId getSessionId() {
        WebDriver driver = this.getWebDriver();
        if (driver instanceof WrapsDriver) {
            WrapsDriver wrapper = (WrapsDriver)driver;
            driver = wrapper.getWrappedDriver();
        }
        return ((RemoteWebDriver)driver).getSessionId();
    }

    default public boolean isLocalBrowser() {
        return this.config().remote() == null;
    }
}

