/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.impl.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesReader {
    private static final Logger log = LoggerFactory.getLogger(PropertiesReader.class);
    private final String fileName;
    private final Lazy<Properties> properties = Lazy.lazyEvaluated(() -> this.loadSelenideProperties());

    public PropertiesReader(String fileName) {
        this.fileName = fileName;
    }

    public synchronized @Nullable String getPropertyOrNull(String key) {
        String value = this.properties.get().getProperty(key, null);
        if (value != null && value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public synchronized String getProperty(String key, String defaultValue) {
        return this.properties.get().getProperty(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Optional.ofNullable(this.getPropertyOrNull(key)).map(Boolean::parseBoolean).orElse(defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return Optional.ofNullable(this.getPropertyOrNull(key)).map(Integer::parseInt).orElse(defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return Optional.ofNullable(this.getPropertyOrNull(key)).map(Long::parseLong).orElse(defaultValue);
    }

    private Properties loadSelenideProperties() {
        Properties result = new Properties();
        this.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), result);
        result.putAll((Map<?, ?>)System.getProperties());
        return result;
    }

    private void loadPropertiesFrom(ClassLoader classLoader, Properties properties) {
        try (InputStream stream = classLoader.getResourceAsStream(this.fileName);){
            if (stream != null) {
                log.debug("Reading settings from {}", (Object)classLoader.getResource(this.fileName));
                properties.load(stream);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + this.fileName + " file from classpath", e);
        }
    }
}

