/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.selector.ByAttribute;
import com.codeborne.selenide.selector.ByDeepShadow;
import com.codeborne.selenide.selector.ByShadow;
import com.codeborne.selenide.selector.ByTagAndText;
import com.codeborne.selenide.selector.ByText;
import com.codeborne.selenide.selector.ByTextCaseInsensitive;
import com.codeborne.selenide.selector.WithTagAndText;
import com.codeborne.selenide.selector.WithText;
import com.codeborne.selenide.selector.WithTextCaseInsensitive;
import org.openqa.selenium.By;

public class Selectors {
    public static By withText(String elementText) {
        return new WithText(elementText);
    }

    public static By withTagAndText(String tag, String elementText) {
        return new WithTagAndText(tag, elementText);
    }

    public static By withTextCaseInsensitive(String elementText) {
        return new WithTextCaseInsensitive(elementText);
    }

    public static By byText(String elementText) {
        return new ByText(elementText);
    }

    public static By byTagAndText(String tag, String elementText) {
        return new ByTagAndText(tag, elementText);
    }

    public static By byTextCaseInsensitive(String elementText) {
        return new ByTextCaseInsensitive(elementText);
    }

    public static By byAttribute(String attributeName, String attributeValue) {
        return new ByAttribute(attributeName, attributeValue);
    }

    public static By shadowCss(String target, String shadowHost, String ... innerShadowHosts) {
        return ByShadow.cssSelector(target, shadowHost, innerShadowHosts);
    }

    public static By shadowDeepCss(String target) {
        return ByDeepShadow.cssSelector(target);
    }

    public static By by(String attributeName, String attributeValue) {
        return Selectors.byAttribute(attributeName, attributeValue);
    }

    public static By byTitle(String title) {
        return Selectors.byAttribute("title", title);
    }

    public static By byValue(String value) {
        return Selectors.byAttribute("value", value);
    }

    public static By byName(String name) {
        return By.name((String)name);
    }

    public static By byXpath(String xpath) {
        return By.xpath((String)xpath);
    }

    public static By byLinkText(String linkText) {
        return By.linkText((String)linkText);
    }

    public static By byPartialLinkText(String partialLinkText) {
        return By.partialLinkText((String)partialLinkText);
    }

    public static By byId(String id) {
        return By.id((String)id);
    }

    public static By byCssSelector(String css) {
        return By.cssSelector((String)css);
    }

    public static By byClassName(String className) {
        return By.className((String)className);
    }

    public static By byTagName(String tagName) {
        return By.tagName((String)tagName);
    }
}

