/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AssertionMode;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.PropertiesReader;
import com.codeborne.selenide.SelectorMode;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.impl.CiReportUrl;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.MutableCapabilities;

public class SelenideConfig
implements Config {
    private final PropertiesReader properties = new PropertiesReader("selenide.properties");
    private String browser = this.getProperty("selenide.browser", "chrome");
    private boolean headless = this.properties.getBoolean("selenide.headless", false);
    private @Nullable String remote = this.getPropertyOrNull("selenide.remote");
    private @Nullable String browserSize = this.getProperty("selenide.browserSize", "1366x768");
    private @Nullable String browserVersion = this.getPropertyOrNull("selenide.browserVersion");
    private @Nullable String browserPosition = this.getPropertyOrNull("selenide.browserPosition");
    private boolean webdriverLogsEnabled = this.properties.getBoolean("selenide.webdriverLogsEnabled", false);
    private @Nullable String browserBinary = this.getPropertyOrNull("selenide.browserBinary");
    private String pageLoadStrategy = this.getProperty("selenide.pageLoadStrategy", "normal");
    private long pageLoadTimeout = Long.parseLong(this.getProperty("selenide.pageLoadTimeout", "30000"));
    private MutableCapabilities browserCapabilities = new MutableCapabilities();
    private String baseUrl = this.getProperty("selenide.baseUrl", "http://localhost:8080");
    private long timeout = Long.parseLong(this.getProperty("selenide.timeout", "4000"));
    private long pollingInterval = Long.parseLong(this.getProperty("selenide.pollingInterval", "200"));
    @Deprecated
    private boolean holdBrowserOpen = this.properties.getBoolean("selenide.holdBrowserOpen", false);
    private boolean reopenBrowserOnFail = this.properties.getBoolean("selenide.reopenBrowserOnFail", true);
    private boolean clickViaJs = this.properties.getBoolean("selenide.clickViaJs", false);
    private boolean screenshots = this.properties.getBoolean("selenide.screenshots", true);
    private boolean savePageSource = this.properties.getBoolean("selenide.savePageSource", true);
    private String reportsFolder = this.getProperty("selenide.reportsFolder", "build/reports/tests");
    private String downloadsFolder = this.getProperty("selenide.downloadsFolder", "build/downloads");
    private @Nullable String reportsUrl = new CiReportUrl().getReportsUrl(this.getPropertyOrNull("selenide.reportsUrl"));
    private boolean fastSetValue = this.properties.getBoolean("selenide.fastSetValue", false);
    private TextCheck textCheck = TextCheck.valueOf(this.getProperty("selenide.textCheck", TextCheck.PARTIAL_TEXT.name()));
    private SelectorMode selectorMode = SelectorMode.valueOf(this.getProperty("selenide.selectorMode", SelectorMode.CSS.name()));
    private AssertionMode assertionMode = AssertionMode.valueOf(this.getProperty("selenide.assertionMode", AssertionMode.STRICT.name()));
    private FileDownloadMode fileDownload = FileDownloadMode.valueOf(this.getProperty("selenide.fileDownload", FileDownloadMode.HTTPGET.name()));
    private boolean proxyEnabled = this.properties.getBoolean("selenide.proxyEnabled", false);
    private @Nullable String proxyHost = this.getPropertyOrNull("selenide.proxyHost");
    private int proxyPort = Integer.parseInt(this.getProperty("selenide.proxyPort", "0"));
    private long remoteReadTimeout = Long.parseLong(this.getProperty("selenide.remoteReadTimeout", "90000"));
    private long remoteConnectionTimeout = Long.parseLong(this.getProperty("selenide.remoteConnectionTimeout", "10000"));

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @CanIgnoreReturnValue
    public SelenideConfig baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @CanIgnoreReturnValue
    public SelenideConfig timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public long pollingInterval() {
        return this.pollingInterval;
    }

    @CanIgnoreReturnValue
    public SelenideConfig pollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    @Override
    @Deprecated
    public boolean holdBrowserOpen() {
        return this.holdBrowserOpen;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public SelenideConfig holdBrowserOpen(boolean holdBrowserOpen) {
        this.holdBrowserOpen = holdBrowserOpen;
        return this;
    }

    @Override
    public boolean reopenBrowserOnFail() {
        return this.reopenBrowserOnFail;
    }

    @CanIgnoreReturnValue
    public SelenideConfig reopenBrowserOnFail(boolean reopenBrowserOnFail) {
        this.reopenBrowserOnFail = reopenBrowserOnFail;
        return this;
    }

    @Override
    public boolean clickViaJs() {
        return this.clickViaJs;
    }

    @CanIgnoreReturnValue
    public SelenideConfig clickViaJs(boolean clickViaJs) {
        this.clickViaJs = clickViaJs;
        return this;
    }

    @Override
    public boolean screenshots() {
        return this.screenshots;
    }

    @CanIgnoreReturnValue
    public SelenideConfig screenshots(boolean screenshots) {
        this.screenshots = screenshots;
        return this;
    }

    @Override
    public boolean savePageSource() {
        return this.savePageSource;
    }

    @CanIgnoreReturnValue
    public SelenideConfig savePageSource(boolean savePageSource) {
        this.savePageSource = savePageSource;
        return this;
    }

    @Override
    public String reportsFolder() {
        return this.reportsFolder;
    }

    @CanIgnoreReturnValue
    public SelenideConfig reportsFolder(String reportsFolder) {
        this.reportsFolder = reportsFolder;
        return this;
    }

    @Override
    public String downloadsFolder() {
        return this.downloadsFolder;
    }

    @CanIgnoreReturnValue
    public SelenideConfig downloadsFolder(String downloadsFolder) {
        this.downloadsFolder = downloadsFolder;
        return this;
    }

    @Override
    public @Nullable String reportsUrl() {
        return this.reportsUrl;
    }

    @CanIgnoreReturnValue
    public SelenideConfig reportsUrl(@Nullable String reportsUrl) {
        this.reportsUrl = reportsUrl;
        return this;
    }

    @Override
    public boolean fastSetValue() {
        return this.fastSetValue;
    }

    @Override
    public TextCheck textCheck() {
        return this.textCheck;
    }

    @CanIgnoreReturnValue
    public SelenideConfig fastSetValue(boolean fastSetValue) {
        this.fastSetValue = fastSetValue;
        return this;
    }

    @CanIgnoreReturnValue
    public SelenideConfig textCheck(TextCheck textCheck) {
        this.textCheck = textCheck;
        return this;
    }

    @Override
    public SelectorMode selectorMode() {
        return this.selectorMode;
    }

    @CanIgnoreReturnValue
    public SelenideConfig selectorMode(SelectorMode selectorMode) {
        this.selectorMode = selectorMode;
        return this;
    }

    @Override
    public AssertionMode assertionMode() {
        return this.assertionMode;
    }

    @CanIgnoreReturnValue
    public SelenideConfig assertionMode(AssertionMode assertionMode) {
        this.assertionMode = assertionMode;
        return this;
    }

    @Override
    public FileDownloadMode fileDownload() {
        return this.fileDownload;
    }

    @CanIgnoreReturnValue
    public SelenideConfig fileDownload(FileDownloadMode fileDownload) {
        this.fileDownload = fileDownload;
        return this;
    }

    @Override
    public boolean proxyEnabled() {
        return this.proxyEnabled;
    }

    @CanIgnoreReturnValue
    public SelenideConfig proxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
        return this;
    }

    @Override
    public @Nullable String proxyHost() {
        return this.proxyHost;
    }

    @CanIgnoreReturnValue
    public SelenideConfig proxyHost(@Nullable String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    @Override
    public int proxyPort() {
        return this.proxyPort;
    }

    @CanIgnoreReturnValue
    public SelenideConfig proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Override
    public String browser() {
        return this.browser;
    }

    @CanIgnoreReturnValue
    public SelenideConfig browser(String browser) {
        this.browser = browser;
        return this;
    }

    @Override
    public boolean headless() {
        return this.headless;
    }

    @CanIgnoreReturnValue
    public SelenideConfig headless(boolean headless) {
        this.headless = headless;
        return this;
    }

    @Override
    public @Nullable String remote() {
        return this.remote;
    }

    @CanIgnoreReturnValue
    public SelenideConfig remote(@Nullable String remote) {
        this.remote = remote;
        return this;
    }

    @Override
    public @Nullable String browserSize() {
        return this.browserSize;
    }

    @CanIgnoreReturnValue
    public SelenideConfig browserSize(@Nullable String browserSize) {
        this.browserSize = browserSize;
        return this;
    }

    @Override
    public @Nullable String browserVersion() {
        return this.browserVersion;
    }

    @CanIgnoreReturnValue
    public SelenideConfig browserVersion(@Nullable String browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @Override
    public @Nullable String browserPosition() {
        return this.browserPosition;
    }

    @CanIgnoreReturnValue
    public SelenideConfig browserPosition(@Nullable String browserPosition) {
        this.browserPosition = browserPosition;
        return this;
    }

    @Override
    public boolean webdriverLogsEnabled() {
        return this.webdriverLogsEnabled;
    }

    @CanIgnoreReturnValue
    public SelenideConfig webdriverLogsEnabled(boolean webdriverLogsEnabled) {
        this.webdriverLogsEnabled = webdriverLogsEnabled;
        return this;
    }

    @Override
    public @Nullable String browserBinary() {
        return this.browserBinary;
    }

    @CanIgnoreReturnValue
    public SelenideConfig browserBinary(@Nullable String browserBinary) {
        this.browserBinary = browserBinary;
        return this;
    }

    @Override
    public String pageLoadStrategy() {
        return this.pageLoadStrategy;
    }

    @Override
    public long pageLoadTimeout() {
        return this.pageLoadTimeout;
    }

    @CanIgnoreReturnValue
    public SelenideConfig pageLoadStrategy(String pageLoadStrategy) {
        this.pageLoadStrategy = pageLoadStrategy;
        return this;
    }

    @CanIgnoreReturnValue
    public SelenideConfig pageLoadTimeout(long pageLoadTimeout) {
        this.pageLoadTimeout = pageLoadTimeout;
        return this;
    }

    @Override
    public MutableCapabilities browserCapabilities() {
        return this.browserCapabilities;
    }

    @CanIgnoreReturnValue
    public SelenideConfig browserCapabilities(MutableCapabilities browserCapabilities) {
        this.browserCapabilities = browserCapabilities;
        return this;
    }

    private @Nullable String getPropertyOrNull(String key) {
        return this.properties.getPropertyOrNull(key);
    }

    private String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public long remoteReadTimeout() {
        return this.remoteReadTimeout;
    }

    @CanIgnoreReturnValue
    public SelenideConfig remoteReadTimeout(long remoteReadTimeout) {
        this.remoteReadTimeout = remoteReadTimeout;
        return this;
    }

    @Override
    public long remoteConnectionTimeout() {
        return this.remoteConnectionTimeout;
    }

    @CanIgnoreReturnValue
    public SelenideConfig remoteConnectionTimeout(long remoteConnectionTimeout) {
        this.remoteConnectionTimeout = remoteConnectionTimeout;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

