/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.ex.AlertNotFoundError;
import com.codeborne.selenide.ex.FrameNotFoundError;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.ex.WindowNotFoundError;
import com.codeborne.selenide.impl.Lists;
import com.codeborne.selenide.impl.windows.FrameByIdOrName;
import com.codeborne.selenide.impl.windows.WindowByIndex;
import com.codeborne.selenide.impl.windows.WindowByNameOrHandle;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private static final String SWITCH_TO = SelenideLogger.getReadableSubject("switchTo", new Object[0]);
    private final Driver driver;
    private final WebDriver webDriver;
    private final Config config;
    private final WebDriver.TargetLocator delegate;

    public SelenideTargetLocator(Driver driver) {
        this.driver = driver;
        this.config = driver.config();
        this.webDriver = driver.getWebDriver();
        this.delegate = this.webDriver.switchTo();
    }

    @CanIgnoreReturnValue
    public WebDriver frame(int index) {
        return this.frame(this.Wait(), index);
    }

    @CanIgnoreReturnValue
    public WebDriver frame(int index, Duration timeout) {
        return this.frame(this.Wait(this.timeoutMs(timeout)), index);
    }

    @CanIgnoreReturnValue
    public WebDriver frame(String nameOrId) {
        return this.frame(this.Wait(), nameOrId);
    }

    @CanIgnoreReturnValue
    public WebDriver frame(String nameOrId, Duration timeout) {
        return this.frame(this.Wait(this.timeoutMs(timeout)), nameOrId);
    }

    @CanIgnoreReturnValue
    private WebDriver frame(SelenideWait wait, int index) {
        return SelenideLogger.get(String.format("frame(index: %s)", index), SWITCH_TO, () -> {
            try {
                return (WebDriver)wait.until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((int)index));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with index: " + index, e);
            }
            catch (InvalidArgumentException e) {
                if (this.isFirefox62Bug(e) || this.isChrome75Error(e)) {
                    throw this.frameNotFoundError("No frame found with index: " + index, e);
                }
                throw e;
            }
        });
    }

    private WebDriver frame(SelenideWait wait, String nameOrId) {
        return SelenideLogger.get("frame(" + nameOrId + ")", SWITCH_TO, () -> {
            try {
                return (WebDriver)wait.until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)nameOrId));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
            }
            catch (InvalidArgumentException e) {
                if (this.isFirefox62Bug(e)) {
                    throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
                }
                throw e;
            }
        });
    }

    @CanIgnoreReturnValue
    public WebDriver frame(WebElement frameElement) {
        return SelenideLogger.get(String.format("frame(%s)", frameElement), SWITCH_TO, () -> {
            try {
                return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((WebElement)frameElement));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
            }
            catch (InvalidArgumentException e) {
                if (this.isFirefox62Bug(e)) {
                    throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
                }
                throw e;
            }
        });
    }

    private boolean isFirefox62Bug(InvalidArgumentException e) {
        return e.getMessage().contains("untagged enum FrameId");
    }

    private boolean isChrome75Error(InvalidArgumentException e) {
        return e.getMessage().contains("invalid argument: 'id' out of range");
    }

    @CanIgnoreReturnValue
    public WebDriver parentFrame() {
        return SelenideLogger.get("parent frame", SWITCH_TO, () -> ((WebDriver.TargetLocator)this.delegate).parentFrame());
    }

    @CanIgnoreReturnValue
    public WebDriver defaultContent() {
        return SelenideLogger.get("default context", SWITCH_TO, () -> ((WebDriver.TargetLocator)this.delegate).defaultContent());
    }

    @CanIgnoreReturnValue
    public WebElement activeElement() {
        return SelenideLogger.get("active element", SWITCH_TO, () -> ((WebDriver.TargetLocator)this.delegate).activeElement());
    }

    @CanIgnoreReturnValue
    public Alert alert() {
        return this.alert(Duration.ofMillis(this.config.timeout()));
    }

    @CanIgnoreReturnValue
    public Alert alert(@Nullable Duration timeout) {
        long timeoutMs = this.timeoutMs(timeout);
        try {
            return (Alert)this.Wait(timeoutMs).until((Function)ExpectedConditions.alertIsPresent());
        }
        catch (TimeoutException e) {
            throw this.alertNotFoundError(e, timeoutMs);
        }
    }

    public void innerFrame(String firstFrame, String ... otherFrames) {
        this.defaultContent();
        for (String frame : Lists.list(firstFrame, otherFrames)) {
            SelenideLogger.run(String.format("frame(%s)", frame), SWITCH_TO, () -> {
                try {
                    this.Wait().until((Function)((Object)new FrameByIdOrName(frame)));
                }
                catch (NoSuchElementException | TimeoutException e) {
                    throw this.frameNotFoundError("No frame found with id/name = " + frame, e);
                }
            });
        }
    }

    @CanIgnoreReturnValue
    public WebDriver window(int index) {
        return this.window(this.Wait(), index);
    }

    @CanIgnoreReturnValue
    public WebDriver window(int index, Duration timeout) {
        return this.window(this.Wait(this.timeoutMs(timeout)), index);
    }

    @CanIgnoreReturnValue
    public WebDriver window(String nameOrHandleOrTitle) {
        return this.window(this.Wait(), nameOrHandleOrTitle);
    }

    @CanIgnoreReturnValue
    public WebDriver window(String nameOrHandleOrTitle, Duration timeout) {
        return this.window(this.Wait(this.timeoutMs(timeout)), nameOrHandleOrTitle);
    }

    private WebDriver window(SelenideWait wait, int index) {
        return SelenideLogger.get(String.format("window(index: %s)", index), SWITCH_TO, () -> {
            try {
                return (WebDriver)wait.until((Function)((Object)new WindowByIndex(index)));
            }
            catch (TimeoutException e) {
                throw this.windowNotFoundError("No window found with index: " + index, e);
            }
        });
    }

    private WebDriver window(SelenideWait wait, String nameOrHandleOrTitle) {
        return SelenideLogger.get(String.format("window(%s)", nameOrHandleOrTitle), SWITCH_TO, () -> {
            try {
                return (WebDriver)wait.until((Function)((Object)new WindowByNameOrHandle(nameOrHandleOrTitle)));
            }
            catch (TimeoutException e) {
                throw this.windowNotFoundError("No window found with name or handle or title: " + nameOrHandleOrTitle, e);
            }
        });
    }

    @CanIgnoreReturnValue
    public WebDriver newWindow(WindowType typeHint) {
        return this.webDriver.switchTo().newWindow(typeHint);
    }

    private SelenideWait Wait() {
        return this.Wait(this.timeoutMs(null));
    }

    private SelenideWait Wait(long timeoutMs) {
        return new SelenideWait(this.webDriver, timeoutMs, this.config.pollingInterval());
    }

    private long timeoutMs(@Nullable Duration timeout) {
        return timeout == null ? this.config.timeout() : timeout.toMillis();
    }

    private Error frameNotFoundError(String message, Throwable cause) {
        FrameNotFoundError error = new FrameNotFoundError(message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error windowNotFoundError(String message, Throwable cause) {
        WindowNotFoundError error = new WindowNotFoundError(message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error alertNotFoundError(Throwable cause, long timeoutMs) {
        AlertNotFoundError error = new AlertNotFoundError(cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), timeoutMs);
    }
}

