/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class GetSelectedOptions
implements Command<ElementsCollection> {
    @Override
    public ElementsCollection execute(SelenideElement proxy, WebElementSource selectElement, Object @Nullable [] args) {
        return new ElementsCollection(new SelectedOptionsCollection(selectElement));
    }

    private static class SelectedOptionsCollection
    implements CollectionSource {
        private final WebElementSource selectElement;
        private Alias alias = Alias.NONE;

        private SelectedOptionsCollection(WebElementSource selectElement) {
            this.selectElement = selectElement;
        }

        @Override
        public List<WebElement> getElements() {
            return Objects.requireNonNull((List)this.selectElement.driver().executeJavaScript("return arguments[0].selectedOptions", this.selectElement.getWebElement()));
        }

        @Override
        public WebElement getElement(int index) {
            return Objects.requireNonNull((WebElement)this.selectElement.driver().executeJavaScript("return arguments[0].selectedOptions[arguments[1]]", this.selectElement.getWebElement(), index));
        }

        @Override
        public String getSearchCriteria() {
            return this.selectElement.description() + " selected options";
        }

        public String toString() {
            return this.selectElement + " selected options";
        }

        @Override
        public Driver driver() {
            return this.selectElement.driver();
        }

        @Override
        public Alias getAlias() {
            return this.alias;
        }

        @Override
        public void setAlias(String alias) {
            this.alias = new Alias(alias);
        }
    }
}

