/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;

public class Util {
    public static int size(@Nullable Object @Nullable [] args) {
        return args == null ? 0 : args.length;
    }

    public static <T> T firstOf(Object @Nullable [] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing arguments");
        }
        return (T)args[0];
    }

    public static List<WebElementCondition> argsToConditions(Object @Nullable [] args) {
        if (args == null) {
            return Collections.emptyList();
        }
        ArrayList<WebElementCondition> conditions = new ArrayList<WebElementCondition>(args.length);
        for (Object arg : args) {
            if (arg instanceof WebElementCondition) {
                WebElementCondition conditionArgument = (WebElementCondition)arg;
                conditions.add(conditionArgument);
                continue;
            }
            if (arg instanceof WebElementCondition[]) {
                WebElementCondition[] conditionsArray = (WebElementCondition[])arg;
                conditions.addAll(Arrays.asList(conditionsArray));
                continue;
            }
            if (arg instanceof String || arg instanceof Long || arg instanceof Duration) continue;
            throw new IllegalArgumentException("Unknown parameter: " + arg);
        }
        return conditions;
    }

    @SafeVarargs
    public static <T> List<T> merge(T first, T ... others) {
        ArrayList<T> result = new ArrayList<T>(1 + others.length);
        result.add(first);
        result.addAll(Arrays.asList(others));
        return Collections.unmodifiableList(result);
    }

    public static List<Integer> merge(int first, int[] others) {
        ArrayList<Integer> result = new ArrayList<Integer>(1 + others.length);
        result.add(first);
        IntStream.of(others).forEach(i -> result.add(i));
        return Collections.unmodifiableList(result);
    }

    public static Map<Object, Object> mergeMaps(Map<?, ?> first, Map<?, ?> second) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(first.size() + second.size());
        result.putAll(first);
        result.putAll(second);
        return result;
    }

    public static <T> T cast(Object value) {
        return (T)value;
    }

    public static <T> String arrayToString(List<T> values) {
        return values.stream().map(Objects::toString).collect(Collectors.joining(","));
    }

    public static <T> Class<T> classOf(T ... reified) {
        if (reified.length > 0) {
            throw new IllegalArgumentException("Please don't pass any values here. Java will detect page object class automagically.");
        }
        return reified.getClass().getComponentType();
    }
}

