/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class DomPropertyValue
extends WebElementCondition {
    private final String domPropertyName;
    protected final @Nullable String expectedDomPropertyValue;

    public DomPropertyValue(String domPropertyName, @Nullable String expectedDomPropertyValue) {
        super(String.format("dom property %s=\"%s\"", domPropertyName, expectedDomPropertyValue));
        this.domPropertyName = domPropertyName;
        this.expectedDomPropertyValue = expectedDomPropertyValue;
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String domPropertyValue = element.getDomProperty(this.domPropertyName);
        return new CheckResult(Objects.equals(this.expectedDomPropertyValue, domPropertyValue), (Object)String.format("%s=\"%s\"", this.domPropertyName, domPropertyValue));
    }
}

