/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.conditions.datetime.DateTimeBetween;
import com.codeborne.selenide.conditions.datetime.DateTimeEquals;
import com.codeborne.selenide.conditions.datetime.DateTimeFormatCondition;
import com.codeborne.selenide.conditions.datetime.TemporalCondition;
import com.codeborne.selenide.conditions.datetime.TemporalFormatCondition;
import java.time.LocalDateTime;

public class DateTimeConditions {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";

    public static TemporalCondition<LocalDateTime> dateTime(LocalDateTime dateTime) {
        return DateTimeConditions.dateTime(dateTime, DEFAULT_PATTERN);
    }

    public static TemporalCondition<LocalDateTime> dateTime(LocalDateTime dateTime, String pattern) {
        return new DateTimeEquals(dateTime, new DateTimeFormatCondition(pattern));
    }

    public static TemporalCondition<LocalDateTime> dateTimeBetween(LocalDateTime from, LocalDateTime until) {
        return DateTimeConditions.dateTimeBetween(from, until, DEFAULT_PATTERN);
    }

    public static TemporalCondition<LocalDateTime> dateTimeBetween(LocalDateTime from, LocalDateTime until, String pattern) {
        return new DateTimeBetween(from, until, new DateTimeFormatCondition(pattern));
    }

    public static TemporalFormatCondition<LocalDateTime> dateTimeFormat(String pattern) {
        return new DateTimeFormatCondition(pattern);
    }
}

