/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.ErrorFormatter;
import com.codeborne.selenide.ex.Strings;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.Screenshot;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriverException;
import org.opentest4j.AssertionFailedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIAssertionError
extends AssertionFailedError {
    private static final Logger log = LoggerFactory.getLogger(UIAssertionError.class);
    protected static final ErrorFormatter errorFormatter = Plugins.inject(ErrorFormatter.class);
    private Screenshot screenshot = Screenshot.none();
    private long timeoutMs;
    private final String initialErrorMessage;
    private @Nullable String detailedErrorMessage;

    protected UIAssertionError(String message) {
        super(message);
        this.initialErrorMessage = message;
    }

    public UIAssertionError(String message, @Nullable Object expected, @Nullable Object actual) {
        super(message, expected, actual);
        this.initialErrorMessage = message;
    }

    protected UIAssertionError(String message, @Nullable Object expected, @Nullable Object actual, long timeoutMs) {
        super(message, expected, actual);
        this.timeoutMs = timeoutMs;
        this.initialErrorMessage = message;
    }

    protected UIAssertionError(String message, @Nullable Throwable cause) {
        super(message, cause);
        this.initialErrorMessage = message;
    }

    protected UIAssertionError(String message, long timeoutMs, @Nullable Throwable cause) {
        super(message, cause);
        this.timeoutMs = timeoutMs;
        this.initialErrorMessage = message;
    }

    protected UIAssertionError(String message, @Nullable Object expected, @Nullable Object actual, @Nullable Throwable cause) {
        super(message, expected, actual, cause);
        this.initialErrorMessage = message;
    }

    protected UIAssertionError(String message, @Nullable Object expected, @Nullable Object actual, @Nullable Throwable cause, long timeoutMs) {
        super(message, expected, actual, cause);
        this.timeoutMs = timeoutMs;
        this.initialErrorMessage = message;
    }

    public final String getMessage() {
        return Objects.requireNonNullElseGet(this.detailedErrorMessage, () -> Strings.join(this.initialErrorMessage, errorFormatter.causedBy(this.getCause())));
    }

    public final String toString() {
        return this.getMessage();
    }

    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    public static Error wrap(Driver driver, Error error, long timeoutMs) {
        return Cleanup.of.isInvalidSelectorError(error) ? error : UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    public static Throwable wrap(Driver driver, WebDriverException error, long timeoutMs) {
        return Cleanup.of.isInvalidSelectorError(error) ? error : UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    private static UIAssertionError wrapThrowable(Driver driver, Throwable error, long timeoutMs) {
        UIAssertionError uiAssertionError;
        UIAssertionError uiError = error instanceof UIAssertionError ? (uiAssertionError = (UIAssertionError)((Object)error)) : UIAssertionError.wrapToUIAssertionError(error);
        uiError.timeoutMs = timeoutMs;
        if (uiError.screenshot.isPresent()) {
            log.warn("UIAssertionError already has screenshot: {} {} -> {}", new Object[]{((Object)((Object)uiError)).getClass().getName(), uiError.getMessage(), uiError.screenshot});
        } else {
            Config config = driver.config();
            uiError.screenshot = ScreenShotLaboratory.getInstance().takeScreenshot(driver, config.screenshots(), config.savePageSource());
            uiError.detailedErrorMessage = Strings.join(uiError.initialErrorMessage, errorFormatter.generateErrorDetails((AssertionError)((Object)uiError), driver, uiError.screenshot, uiError.timeoutMs));
        }
        return uiError;
    }

    private static UIAssertionError wrapToUIAssertionError(Throwable error) {
        String message = Cleanup.of.webdriverExceptionMessage(error);
        return new UIAssertionError(message, error);
    }
}

