/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class Arguments {
    private final @Nullable Object @Nullable [] args;

    public Arguments(Object ... args) {
        this.args = args;
    }

    public <T> Optional<T> ofType(Class<T> klass) {
        if (this.args == null) {
            return Optional.empty();
        }
        for (Object arg : this.args) {
            if (arg == null || !klass.isAssignableFrom(arg.getClass())) continue;
            return Optional.of(arg);
        }
        return Optional.empty();
    }

    public <T> @Nullable T nth(int index) {
        if (this.args == null) {
            throw new IllegalArgumentException("Missing arguments");
        }
        if (index >= this.args.length) {
            throw new IllegalArgumentException("Missing argument #" + index + " in " + Arrays.toString(this.args));
        }
        return (T)this.args[index];
    }

    public long getTimeoutMs(long defaultTimeout) {
        return this.ofType(Duration.class).map(Duration::toMillis).orElseGet(() -> this.ofType(HasTimeout.class).map(HasTimeout::timeout).map(Duration::toMillis).orElseGet(() -> this.ofType(Long.class).orElse(defaultTimeout)));
    }
}

