/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public interface ElementDescriber {
    public String fully(Driver var1, @Nullable WebElement var2);

    public String briefly(Driver var1, WebElement var2);

    public String selector(By var1);

    default public String fully(Driver driver, @Nullable Collection<WebElement> elements) {
        if (elements == null) {
            return "[not loaded yet...]";
        }
        if (elements.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[").append(System.lineSeparator()).append("\t");
        for (WebElement element : elements) {
            if (sb.length() > 4) {
                sb.append(",").append(System.lineSeparator()).append("\t");
            }
            sb.append(this.fully(driver, element));
        }
        sb.append(System.lineSeparator()).append("]");
        return sb.toString();
    }
}

